/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.collect;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.math.Numbers;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PartitionMap<K, V>
extends AbstractSet<Map<K, V>>
implements Iterator<Map<K, V>> {
    private final Iterator<Map.Entry<K, V>> iterator;
    private final int size;
    private final int totalSize;
    private int current;

    public PartitionMap(Map<K, V> map, int size) {
        this.iterator = map.entrySet().iterator();
        this.size = size;
        this.totalSize = map.size();
    }

    @Override
    public int size() {
        return (this.totalSize + this.size - 1) / this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.totalSize == 0;
    }

    @Override
    public Iterator<Map<K, V>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.size() > this.current;
    }

    @Override
    public Map<K, V> next() {
        if (!this.hasNext()) {
            throw Exceptions.noSuchElement("there are no more elements");
        }
        ++this.current;
        HashMap<K, V> map = new HashMap<K, V>(Numbers.getMin2Power(this.size));
        for (int i = 0; i < this.size && this.iterator.hasNext(); ++i) {
            Map.Entry<K, V> next = this.iterator.next();
            map.put(next.getKey(), next.getValue());
        }
        return map;
    }
}

