/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.collect;

import com.orion.lang.define.collect.MultiMap;
import java.io.Serializable;
import java.util.LinkedHashMap;

public class MultiLinkedHashMap<E, K, V>
extends LinkedHashMap<E, LinkedHashMap<K, V>>
implements MultiMap<E, K, V, LinkedHashMap<K, V>>,
Serializable {
    private static final long serialVersionUID = 1237895897912782748L;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private int keyInitialCapacity;
    private float keyLoadFactor;
    private boolean keyAccessOrder;

    public MultiLinkedHashMap() {
        super(16);
    }

    public MultiLinkedHashMap(int elementInitialCapacity) {
        this(elementInitialCapacity, 0.75f, false);
    }

    public MultiLinkedHashMap(int elementInitialCapacity, float loadFactor) {
        this(elementInitialCapacity, loadFactor, false);
    }

    public MultiLinkedHashMap(int elementInitialCapacity, float loadFactor, boolean accessOrder) {
        super(elementInitialCapacity, loadFactor, accessOrder);
        this.keyInitialCapacity = 16;
        this.keyLoadFactor = 0.75f;
        this.keyAccessOrder = false;
    }

    public void keyCapacity(int keyInitialCapacity) {
        this.keyCapacity(keyInitialCapacity, 0.75f, false);
    }

    public void keyCapacity(int keyInitialCapacity, float keyLoadFactor) {
        this.keyCapacity(keyInitialCapacity, keyLoadFactor, false);
    }

    public void keyCapacity(int keyInitialCapacity, float keyLoadFactor, boolean keyAccessOrder) {
        this.keyInitialCapacity = keyInitialCapacity;
        this.keyLoadFactor = keyLoadFactor;
        this.keyAccessOrder = keyAccessOrder;
    }

    @Override
    public LinkedHashMap<K, V> computeSpace(E e) {
        return super.computeIfAbsent(e, k -> new LinkedHashMap(this.keyInitialCapacity, this.keyLoadFactor, this.keyAccessOrder));
    }
}

