/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.collect;

import com.orion.lang.constant.Const;
import com.orion.lang.utils.Valid;
import java.util.ArrayList;
import java.util.Collection;

public class FixedArrayList<E>
extends ArrayList<E> {
    private final int maxSize;

    public FixedArrayList(int maxSize) {
        this.maxSize = Valid.gt(maxSize, Const.N_0);
    }

    @Override
    public boolean add(E e) {
        this.removeIfFull(1);
        return super.add(e);
    }

    @Override
    public void add(int index, E element) {
        this.removeIfFull(1);
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Valid.lte(c.size(), this.maxSize);
        this.removeIfFull(c.size());
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Valid.lte(c.size(), this.maxSize);
        this.removeIfFull(c.size());
        return super.addAll(index, c);
    }

    private void removeIfFull(int count) {
        int newSize = this.size() + count;
        if (newSize > this.maxSize) {
            this.subList(0, newSize - this.maxSize).clear();
        }
    }
}

