/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Objects1;
import com.orion.lang.utils.Stacks;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.io.Streams;
import java.util.StringJoiner;

public class Console {
    private Console() {
    }

    public static void log() {
        System.out.println();
    }

    public static void log(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.log(e, e.getMessage(), new Object[0]);
        } else {
            Console.log((Throwable)null, Strings.str(obj), new Object[0]);
        }
    }

    public static void log(String tpl, Object ... values) {
        Console.log(null, tpl, values);
    }

    public static void log(Throwable t, String tpl, Object ... values) {
        System.out.println(Strings.format(tpl, values));
        if (t != null) {
            Exceptions.printStacks(t);
            Streams.flush(System.out);
        }
    }

    public static void error() {
        System.err.println();
    }

    public static void error(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.error(e, e.getMessage(), new Object[0]);
        } else {
            Console.error((Throwable)null, Strings.str(obj), new Object[0]);
        }
    }

    public static void error(String tpl, Object ... values) {
        Console.error(null, tpl, values);
    }

    public static void error(Throwable t, String tpl, Object ... values) {
        System.err.println(Strings.format(tpl, values));
        if (t != null) {
            Exceptions.printStacks(t);
            Streams.flush(System.err);
        }
    }

    public static void trace(Object ... os) {
        StringJoiner joiner = new StringJoiner(" ");
        if (os != null) {
            for (Object o : os) {
                joiner.add(Objects1.toString(o));
            }
        }
        System.out.println(joiner);
    }

    public static String stack() {
        return Stacks.currentStack().toRawString();
    }

    public static Integer line() {
        return Stacks.currentLineNumber();
    }
}

