/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.support;

import com.orion.lang.utils.Exceptions;

public enum HttpMethod {
    GET("GET"),
    POST("POST"),
    PUT("PUT"),
    DELETE("DELETE"),
    PATCH("PATCH"),
    HEAD("HEAD"),
    OPTIONS("OPTIONS"),
    TRACE("TRACE");

    private final String method;

    private HttpMethod(String method) {
        this.method = method;
    }

    public String method() {
        return this.method;
    }

    public static void valid(String method) {
        HttpMethod.valid(method, HttpMethod.values().length);
    }

    public static void valid(String method, int length) {
        boolean opt = false;
        method = method.trim().toUpperCase();
        for (int i = 0; i < length; ++i) {
            HttpMethod m = HttpMethod.values()[i];
            if (!m.method().equals(method)) continue;
            opt = true;
            break;
        }
        if (!opt) {
            throw Exceptions.httpUnsupportedMethod((String)"the method is not supported");
        }
    }
}

