/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.parse;

import com.orion.http.parse.ParseRequest;
import com.orion.http.parse.ParseResponse;
import com.orion.http.support.HttpContentType;
import com.orion.http.support.HttpMethod;
import java.util.Map;

public class ParseRequests {
    private ParseRequests() {
    }

    public static ParseResponse get(String url) {
        return new ParseRequest(url).await();
    }

    public static ParseResponse get(String url, Map<String, ?> params) {
        ParseRequest request = new ParseRequest(url);
        request.queryParams(params);
        return request.await();
    }

    public static ParseResponse post(String url) {
        ParseRequest request = new ParseRequest(url);
        request.method(HttpMethod.POST);
        return request.await();
    }

    public static ParseResponse post(String url, byte[] body) {
        ParseRequest request = new ParseRequest(url);
        request.method(HttpMethod.POST).contentType(HttpContentType.APPLICATION_JSON).body(body);
        return request.await();
    }

    public static ParseResponse post(String url, String body) {
        ParseRequest request = new ParseRequest(url);
        request.method(HttpMethod.POST).contentType(HttpContentType.APPLICATION_JSON).body(body);
        return request.await();
    }

    public static ParseResponse post(String url, String contentType, byte[] body) {
        ParseRequest request = new ParseRequest(url);
        request.method(HttpMethod.POST).contentType(contentType).body(body);
        return request.await();
    }

    public static ParseResponse post(String url, String contentType, String body) {
        ParseRequest request = new ParseRequest(url);
        request.method(HttpMethod.POST).contentType(contentType).body(body);
        return request.await();
    }

    public static ParseResponse post(String url, Map<String, String> formParts) {
        ParseRequest request = new ParseRequest(url);
        request.method(HttpMethod.POST).formParts(formParts);
        return request.await();
    }

    public static ParseRequest get() {
        return new ParseRequest();
    }

    public static ParseRequest post() {
        ParseRequest request = new ParseRequest();
        request.method(HttpMethod.POST);
        return request;
    }
}

