/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.ok.ws;

import com.orion.http.ok.ws.handler.CloseHandler;
import com.orion.http.ok.ws.handler.FailureHandler;
import com.orion.http.ok.ws.handler.MessageByteHandler;
import com.orion.http.ok.ws.handler.MessageHandler;
import com.orion.http.ok.ws.handler.OpenHandler;
import com.orion.http.ok.ws.handler.SendMessageByteHandler;
import com.orion.http.ok.ws.handler.SendMessageHandler;
import com.orion.http.ok.ws.handler.ShutdownHandler;
import com.orion.lang.id.Sequences;
import com.orion.lang.utils.Threads;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkWebSocketServer
extends WebSocketListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(OkWebSocketServer.class);
    private final MockWebServer server = new MockWebServer();
    private final InetAddress address;
    private final int port;
    private int shutDownWaitClientTime;
    private int maxClientCount;
    private OpenHandler openHandler;
    private MessageHandler messageHandler;
    private MessageByteHandler messageByteHandler;
    private CloseHandler closeHandler;
    private FailureHandler failureHandler;
    private ShutdownHandler shutdownHandler;
    private SendMessageHandler sendTextHandler;
    private SendMessageByteHandler sendByteHandler;
    private final Map<String, WebSocket> clients;

    public OkWebSocketServer(int port) {
        this(null, port);
    }

    public OkWebSocketServer(InetAddress address, int port) {
        this.address = address;
        this.port = port;
        this.shutDownWaitClientTime = 3000;
        this.clients = new ConcurrentHashMap<String, WebSocket>();
    }

    public void start() throws IOException {
        if (this.address != null) {
            this.server.start(this.address, this.port);
        } else {
            this.server.start(this.port);
        }
        LOGGER.info("WebSocketServer \u521d\u59cb\u5316\u5b8c\u6210 host: [{}], port: [{}]", (Object)this.server.getHostName(), (Object)this.server.getPort());
        this.server.enqueue(new MockResponse().withWebSocketUpgrade((WebSocketListener)this));
    }

    public void shutdown() throws IOException {
        if (this.shutdownHandler != null) {
            this.shutdownHandler.shutdown(this.clients);
        }
        for (WebSocket value : this.clients.values()) {
            value.close(3002, "Server \u5173\u95ed\u8fde\u63a5");
        }
        this.clients.clear();
        Threads.sleep((long)this.shutDownWaitClientTime);
        this.server.shutdown();
    }

    public OkWebSocketServer shutDownWaitClientTime(int timeout) {
        if (timeout >= 1000) {
            this.shutDownWaitClientTime = timeout;
        }
        return this;
    }

    public OkWebSocketServer maxClientCount(int maxCount) {
        if (maxCount > 0) {
            this.maxClientCount = maxCount;
        }
        return this;
    }

    public void broadcast(String text) {
        for (WebSocket webSocket : this.clients.values()) {
            if (this.sendTextHandler != null) {
                this.sendTextHandler.send(webSocket, text);
            }
            webSocket.send(text);
        }
    }

    public void broadcast(byte[] bs) {
        this.broadcast(ByteString.of((byte[])bs));
    }

    public void broadcast(byte[] bs, int offset, int len) {
        this.broadcast(ByteString.of((byte[])bs, (int)offset, (int)len));
    }

    public void broadcast(ByteString bs) {
        for (WebSocket webSocket : this.clients.values()) {
            if (this.sendByteHandler != null) {
                this.sendByteHandler.send(webSocket, bs);
            }
            webSocket.send(bs);
        }
    }

    public void spread(String sessionId, String text) {
        WebSocket webSocket = this.clients.get(sessionId);
        if (webSocket == null) {
            return;
        }
        this.spread(webSocket, text);
    }

    public void spread(String sessionId, byte[] bs) {
        this.spread(sessionId, ByteString.of((byte[])bs));
    }

    public void spread(String sessionId, byte[] bs, int offset, int len) {
        this.spread(sessionId, ByteString.of((byte[])bs, (int)offset, (int)len));
    }

    public void spread(String sessionId, ByteString bs) {
        WebSocket webSocket = this.clients.get(sessionId);
        if (webSocket == null) {
            return;
        }
        this.spread(webSocket, bs);
    }

    public void spread(WebSocket webSocket, String text) {
        if (webSocket == null) {
            return;
        }
        if (this.sendTextHandler != null) {
            this.sendTextHandler.send(webSocket, text);
        }
        webSocket.send(text);
    }

    public void spread(WebSocket webSocket, byte[] bs) {
        this.spread(webSocket, ByteString.of((byte[])bs));
    }

    public void spread(WebSocket webSocket, byte[] bs, int offset, int len) {
        this.spread(webSocket, ByteString.of((byte[])bs, (int)offset, (int)len));
    }

    public void spread(WebSocket webSocket, ByteString bs) {
        if (webSocket == null) {
            return;
        }
        if (this.sendByteHandler != null) {
            this.sendByteHandler.send(webSocket, bs);
        }
        webSocket.send(bs);
    }

    public void onOpen(WebSocket webSocket, Response response) {
        String clientSessionId;
        if (this.maxClientCount != 0 && this.clients.size() >= this.maxClientCount) {
            webSocket.close(3002, "Server \u8fde\u63a5\u5df2\u6ee1 \u5173\u95ed\u8fde\u63a5");
            LOGGER.warn("WebSocketServer-Client\u5efa\u7acb\u8fde\u63a5\u5931\u8d25-\u8d85\u51fa\u6700\u5927\u6570\u91cf response: [{}]", (Object)response);
            this.server.enqueue(new MockResponse().withWebSocketUpgrade((WebSocketListener)this));
            return;
        }
        LOGGER.info("WebSocketServer-Client\u5df2\u5efa\u7acb\u8fde\u63a5 response: [{}]", (Object)response);
        if (this.openHandler != null) {
            this.openHandler.open(webSocket, response);
        }
        if ((clientSessionId = response.request().header("Mock-Client-Session-Id")) == null) {
            clientSessionId = "TEMP-" + Sequences.nextId();
        }
        this.clients.put(clientSessionId, webSocket);
        LOGGER.info("WebSocketServer-\u8fde\u63a5ClientSessionId: [{}], \u5f53\u524d\u8fde\u63a5\u6570\u91cf: [{}]", (Object)clientSessionId, (Object)this.clients.size());
        this.server.enqueue(new MockResponse().withWebSocketUpgrade((WebSocketListener)this));
    }

    public void onMessage(WebSocket webSocket, String text) {
        LOGGER.debug("WebSocketServer-\u6536\u5230Client Text\u4fe1\u606f msg: '{}'", (Object)text);
        if (this.messageHandler != null) {
            this.messageHandler.message(webSocket, text);
        }
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        LOGGER.debug("WebSocketServer\u6536\u5230Client Byte\u4fe1\u606f size: '{}'", (Object)bytes.size());
        if (this.messageByteHandler != null) {
            this.messageByteHandler.message(webSocket, bytes);
        }
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        LOGGER.info("WebSocketServer-\u51c6\u5907\u5173\u95edClient\u8fde\u63a5 code: {}, reason: '{}'", (Object)code, (Object)reason);
        if (this.closeHandler != null) {
            this.closeHandler.close(webSocket, code, reason);
        }
        String remove = this.remove(webSocket);
        boolean close = webSocket.close(code, reason);
        LOGGER.info("WebSocketServer-\u5173\u95edClient\u8fde\u63a5\u5b8c\u6210 code: {}, reason: '{}', close: {}, remove: {}", new Object[]{code, reason, close, remove});
        LOGGER.info("WebSocketServer-\u5f53\u524dClient\u8fde\u63a5\u6570\u91cf: [{}]", (Object)this.clients.size());
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        LOGGER.info("WebSocketServer-Client\u8fde\u63a5\u5df2\u5173\u95ed, code: {}, reason: '{}', \u5f53\u524d\u8fde\u63a5\u6570\u91cf: [{}]", new Object[]{code, reason, this.clients.size()});
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        if (this.failureHandler != null) {
            this.failureHandler.failure(webSocket, t, response);
        }
        String remove = this.remove(webSocket);
        boolean close = webSocket.close(3001, "Server \u5173\u95edFail\u8fde\u63a5");
        LOGGER.error("WebSocketServer-\u5904\u7406Client\u8fde\u63a5\u5931\u8d25 close: {}, remove: {}, error: {}-{}, response: {}", new Object[]{close, remove, t.getClass().getName(), t.getMessage(), response});
    }

    private String remove(WebSocket client) {
        String key = null;
        Set<Map.Entry<String, WebSocket>> entries = this.clients.entrySet();
        for (Map.Entry<String, WebSocket> entry : entries) {
            if (!entry.getValue().equals(client)) continue;
            key = entry.getKey();
            break;
        }
        if (key != null) {
            this.clients.remove(key);
        }
        return key;
    }

    public OkWebSocketServer openHandler(OpenHandler openHandler) {
        this.openHandler = openHandler;
        return this;
    }

    public OkWebSocketServer messageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    public OkWebSocketServer messageByteHandler(MessageByteHandler messageByteHandler) {
        this.messageByteHandler = messageByteHandler;
        return this;
    }

    public OkWebSocketServer sendMessageByteHandler(SendMessageByteHandler sendMessageByteHandler) {
        this.sendByteHandler = sendMessageByteHandler;
        return this;
    }

    public OkWebSocketServer sendTextHandler(SendMessageHandler sendTextHandler) {
        this.sendTextHandler = sendTextHandler;
        return this;
    }

    public OkWebSocketServer closeHandler(CloseHandler closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    public OkWebSocketServer failureHandler(FailureHandler failureHandler) {
        this.failureHandler = failureHandler;
        return this;
    }

    public OkWebSocketServer shutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
        return this;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public int getClientCount() {
        return this.clients.size();
    }
}

