/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.ok.file;

import com.orion.http.BaseHttpRequest;
import com.orion.http.ok.BaseOkRequest;
import com.orion.http.ok.OkRequests;
import com.orion.http.ok.OkResponse;
import com.orion.http.support.HttpContentType;
import com.orion.http.support.HttpMethod;
import com.orion.http.support.HttpUploadPart;
import com.orion.lang.able.Asyncable;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OkAsyncUpload
extends BaseOkRequest
implements Asyncable<Consumer<OkResponse>> {
    private Collection<HttpUploadPart> parts;
    private boolean asyncFailThrows;

    public OkAsyncUpload(String url) {
        this(url, OkRequests.getClient());
    }

    public OkAsyncUpload(String url, OkHttpClient client) {
        this.url = url;
        this.client = client;
        this.method = HttpMethod.POST.method();
    }

    public OkAsyncUpload asyncFailThrows(boolean asyncFailThrows) {
        this.asyncFailThrows = asyncFailThrows;
        return this;
    }

    public OkAsyncUpload asyncFailThrows() {
        this.asyncFailThrows = true;
        return this;
    }

    @Override
    public OkAsyncUpload method(HttpMethod method) {
        return this.method(method.method());
    }

    @Override
    public OkAsyncUpload method(String method) {
        this.method = method;
        if (super.isNoBodyRequest()) {
            throw Exceptions.unsupported((String)("unsupported method " + method));
        }
        return this;
    }

    @Override
    public BaseHttpRequest body(String body) {
        throw Exceptions.unsupported((String)"upload file unsupported set body");
    }

    @Override
    public BaseHttpRequest body(byte[] body) {
        throw Exceptions.unsupported((String)"upload file unsupported set body");
    }

    @Override
    public BaseHttpRequest body(byte[] body, int offset, int len) {
        throw Exceptions.unsupported((String)"upload file unsupported set body");
    }

    @Override
    public BaseHttpRequest contentType(String contentType) {
        throw Exceptions.unsupported((String)"upload file unsupported set contentType");
    }

    @Override
    public BaseHttpRequest contentType(HttpContentType contentType) {
        throw Exceptions.unsupported((String)"upload file unsupported set contentType");
    }

    public OkAsyncUpload part(HttpUploadPart part) {
        this.parts = Lists.singleton((Object)part);
        return this;
    }

    public OkAsyncUpload parts(Collection<HttpUploadPart> parts) {
        this.parts = parts;
        return this;
    }

    @Override
    protected void setBody(Request.Builder requestBuilder) {
        super.setMultipartBody(requestBuilder, this.parts);
    }

    public void async(final Consumer<OkResponse> callback) {
        Valid.notNull(callback, (String)"async call back is null", (Object[])new Object[0]);
        super.buildRequest();
        this.call = this.client.newCall(this.request);
        final OkResponse response = new OkResponse(this.url, this.tag);
        this.call.enqueue(new Callback(){

            public void onResponse(Call call, Response res) {
                response.asyncSetResponse(res);
                callback.accept(response);
            }

            public void onFailure(Call call, IOException e) {
                response.error(e);
                if (OkAsyncUpload.this.asyncFailThrows) {
                    throw Exceptions.httpRequest((String)OkAsyncUpload.this.url, (String)("async ok upload file on failure: " + OkAsyncUpload.super.getRequestMessage()), (Throwable)e);
                }
                callback.accept(response);
            }
        });
    }
}

