/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.ok;

import com.orion.http.BaseHttpRequest;
import com.orion.http.support.HttpMethod;
import com.orion.http.support.HttpUploadPart;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public abstract class BaseOkRequest
extends BaseHttpRequest {
    protected Object tag;
    protected Call call;
    protected Request request;
    protected OkHttpClient client;

    public BaseOkRequest client(OkHttpClient client) {
        this.client = client;
        return this;
    }

    public BaseOkRequest tag(Object tag) {
        this.tag = tag;
        return this;
    }

    public BaseOkRequest cancel() {
        Valid.notNull((Object)this.call, (String)"request not call", (Object[])new Object[0]);
        this.call.cancel();
        return this;
    }

    @Override
    protected void buildRequest() {
        boolean noBody;
        super.buildRequest();
        Request.Builder requestBuilder = new Request.Builder();
        HttpMethod.valid(this.method, 6);
        requestBuilder.url(this.url);
        if (this.headers != null) {
            this.headers.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        if (this.cookies != null) {
            this.cookies.forEach(c -> requestBuilder.addHeader("Cookie", c.toString()));
        }
        if (this.ignoreHeaders != null) {
            this.ignoreHeaders.forEach(arg_0 -> ((Request.Builder)requestBuilder).removeHeader(arg_0));
        }
        if (this.tag != null) {
            requestBuilder.tag(this.tag);
        }
        if (noBody = super.isNoBodyRequest()) {
            requestBuilder.method(this.method, null);
        } else {
            this.setBody(requestBuilder);
        }
        this.request = requestBuilder.build();
    }

    protected void setBody(Request.Builder requestBuilder) {
        if (this.body != null) {
            requestBuilder.method(this.method, RequestBody.create((MediaType)MediaType.parse((String)(this.contentType + "; charset=" + this.charset)), (byte[])this.body, (int)this.bodyOffset, (int)this.bodyLen));
        } else if (this.formParts != null) {
            FormBody.Builder formBuilder = new FormBody.Builder(Charset.forName(this.charset));
            this.formParts.forEach((arg_0, arg_1) -> ((FormBody.Builder)formBuilder).addEncoded(arg_0, arg_1));
            requestBuilder.method(this.method, (RequestBody)formBuilder.build());
        } else {
            requestBuilder.method(this.method, RequestBody.create((MediaType)MediaType.parse((String)(this.contentType + "; charset=" + this.charset)), (String)""));
        }
    }

    protected void setMultipartBody(Request.Builder requestBuilder, Collection<HttpUploadPart> parts) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (this.formParts != null) {
            this.formParts.forEach((arg_0, arg_1) -> ((MultipartBody.Builder)builder).addFormDataPart(arg_0, arg_1));
        }
        for (HttpUploadPart part : parts) {
            if (part == null) continue;
            RequestBody body = null;
            if (part.getIn() != null) {
                try {
                    body = RequestBody.create((MediaType)MediaType.parse((String)part.getContentType()), (byte[])Streams.toByteArray((InputStream)part.getIn()));
                }
                catch (IOException e) {
                    throw Exceptions.ioRuntime((String)"set upload file error", (Throwable)e);
                }
            } else if (part.getFile() != null) {
                body = RequestBody.create((MediaType)MediaType.parse((String)part.getContentType()), (File)part.getFile());
            } else if (part.getBytes() != null) {
                body = RequestBody.create((MediaType)MediaType.parse((String)part.getContentType()), (byte[])part.getBytes(), (int)part.getOff(), (int)part.getLen());
            }
            if (body == null) continue;
            builder.addFormDataPart(part.getParam(), part.getFileName(), body);
        }
        requestBuilder.method(this.method, (RequestBody)builder.build());
    }

    protected String getRequestMessage() {
        StringBuilder builder = new StringBuilder().append(this.request.method()).append(" ").append(this.request.url());
        Object tag = this.request.tag();
        if (tag != null) {
            builder.append(" tag: ").append(tag);
        }
        return builder.toString();
    }

    public Request getRequest() {
        return this.request;
    }

    public Call getCall() {
        return this.call;
    }

    public Object getTag() {
        return this.tag;
    }

    public OkHttpClient getClient() {
        return this.client;
    }
}

