/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.apache;

import com.orion.http.apache.ApacheClientBuilder;
import com.orion.http.apache.ApacheRequest;
import com.orion.http.apache.ApacheResponse;
import com.orion.http.apache.file.ApacheDownload;
import com.orion.http.apache.file.ApacheUpload;
import com.orion.http.support.HttpContentType;
import com.orion.http.support.HttpMethod;
import java.util.Map;
import org.apache.http.impl.client.CloseableHttpClient;

public class ApacheRequests {
    private static CloseableHttpClient client = ApacheClientBuilder.create().logInterceptor().build();

    private ApacheRequests() {
    }

    public static ApacheResponse get(String url) {
        return new ApacheRequest(url).await();
    }

    public static ApacheResponse get(String url, Map<String, ?> params) {
        ApacheRequest request = new ApacheRequest(url);
        request.queryParams(params);
        return request.await();
    }

    public static ApacheResponse post(String url) {
        ApacheRequest request = new ApacheRequest(url);
        request.method(HttpMethod.POST);
        return request.await();
    }

    public static ApacheResponse post(String url, byte[] body) {
        ApacheRequest request = new ApacheRequest(url);
        request.method(HttpMethod.POST).contentType(HttpContentType.APPLICATION_JSON).body(body);
        return request.await();
    }

    public static ApacheResponse post(String url, String body) {
        ApacheRequest request = new ApacheRequest(url);
        request.method(HttpMethod.POST).contentType(HttpContentType.APPLICATION_JSON).body(body);
        return request.await();
    }

    public static ApacheResponse post(String url, String contentType, byte[] body) {
        ApacheRequest request = new ApacheRequest(url);
        request.method(HttpMethod.POST).contentType(contentType).body(body);
        return request.await();
    }

    public static ApacheResponse post(String url, String contentType, String body) {
        ApacheRequest request = new ApacheRequest(url);
        request.method(HttpMethod.POST).contentType(contentType).body(body);
        return request.await();
    }

    public static ApacheRequest get() {
        return new ApacheRequest();
    }

    public static ApacheRequest post() {
        ApacheRequest request = new ApacheRequest();
        request.method(HttpMethod.POST);
        return request;
    }

    public static ApacheDownload download(String url) {
        return new ApacheDownload(url);
    }

    public static ApacheDownload download(String url, CloseableHttpClient client) {
        return new ApacheDownload(url, client);
    }

    public static ApacheUpload upload(String url) {
        return new ApacheUpload(url);
    }

    public static ApacheUpload upload(String url, CloseableHttpClient client) {
        return new ApacheUpload(url, client);
    }

    public static CloseableHttpClient getClient() {
        return client;
    }

    public static void setClient(CloseableHttpClient client) {
        ApacheRequests.client = client;
    }
}

