/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.apache;

import com.orion.lang.define.wrapper.Tuple;
import com.orion.lang.id.UUIds;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheLoggerInterceptor
implements HttpRequestInterceptor,
HttpResponseInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApacheLoggerInterceptor.class);
    private static final ThreadLocal<Tuple> HOLDER = new ThreadLocal();
    private static final String DEF = "HTTP-Request ";
    private String suffix;

    public ApacheLoggerInterceptor() {
        this(DEF);
    }

    public ApacheLoggerInterceptor(String suffix) {
        this.suffix = suffix;
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        long start = System.currentTimeMillis();
        RequestLine request = httpRequest.getRequestLine();
        String method = request.getMethod();
        String uri = request.getUri();
        String traceId = UUIds.random32();
        HOLDER.set(Tuple.of((Object[])new Object[]{method, uri, start, traceId}));
        LOGGER.info(this.suffix + "START method: [{}], url: [{}], start: [{}], traceId: [{}]", new Object[]{method, uri, start, traceId});
    }

    public void process(HttpResponse httpResponse, HttpContext httpContext) {
        long end = System.currentTimeMillis();
        Tuple tuple = HOLDER.get();
        HOLDER.remove();
        StatusLine response = httpResponse.getStatusLine();
        int code = response.getStatusCode();
        LOGGER.info(this.suffix + "END [use: {}ms], code: {}, method: [{}], url: [{}], traceId: [{}]", new Object[]{end - (Long)tuple.get(2), code, tuple.get(0), tuple.get(1), tuple.get(3)});
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

