/*
 * Decompiled with CFR 0.152.
 */
package com.orion.generator.idcard;

import com.orion.generator.addres.AddressGenerator;
import com.orion.generator.addres.AddressSupport;
import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.identity.IdCards;
import com.orion.lang.utils.random.Randoms;
import com.orion.lang.utils.time.Birthdays;
import com.orion.lang.utils.time.DateStream;
import com.orion.lang.utils.time.Dates;
import java.util.Date;

public class IdCardGenerator {
    private static final int[] MAN_GENDER_CODE = new int[]{1, 3, 5, 7, 9};
    private static final int[] WOMAN_GENDER_CODE = new int[]{0, 2, 4, 6, 8};
    private static final int AGE_MIN = 18;
    private static final int AGE_MAX = 50;
    private static final String PSB = "\u516c\u5b89\u5c40";

    private IdCardGenerator() {
    }

    public static String generator() {
        return IdCardGenerator.generator(AGE_MIN, AGE_MAX);
    }

    public static String generator(int ageMin, int ageMax) {
        return IdCardGenerator.generator(AddressSupport.randomCountyCode().toString(), ageMin, ageMax, Randoms.randomBoolean());
    }

    public static String generator(String code, int ageMin, int ageMax) {
        return IdCardGenerator.generator(code, ageMin, ageMax, Randoms.randomBoolean());
    }

    public static String generator(int ageMin, int ageMax, boolean gender) {
        return IdCardGenerator.generator(AddressSupport.randomCountyCode().toString(), ageMin, ageMax, gender);
    }

    public static String generator(String code, int ageMin, int ageMax, boolean gender) {
        return IdCardGenerator.generator(code, Randoms.randomInt((int)ageMin, (int)(ageMax + 1)), gender);
    }

    public static String generator(int age) {
        return IdCardGenerator.generator(AddressSupport.randomCountyCode().toString(), age, Randoms.randomBoolean());
    }

    public static String generator(String code, int age) {
        return IdCardGenerator.generator(code, age, Randoms.randomBoolean());
    }

    public static String generator(int age, boolean gender) {
        return IdCardGenerator.generator(AddressSupport.randomCountyCode().toString(), age, gender);
    }

    public static String generator(String code, int age, boolean gender) {
        return IdCardGenerator.generator(code, Birthdays.generatorBirthday((int)age), gender);
    }

    public static String generator(String birthday) {
        return IdCardGenerator.generator(AddressSupport.randomCountyCode().toString(), birthday, Randoms.randomBoolean());
    }

    public static String generator(String birthday, boolean gender) {
        return IdCardGenerator.generator(AddressSupport.randomCountyCode().toString(), birthday, gender);
    }

    public static String generator(String code, String birthday) {
        return IdCardGenerator.generator(code, birthday, Randoms.randomBoolean());
    }

    public static String generator(String code, String birthday, boolean gender) {
        String seq = Strings.leftPad((String)(Randoms.randomInt((int)100) + ""), (int)2, (String)"0");
        int genderCode = Arrays1.random((int[])(gender ? MAN_GENDER_CODE : WOMAN_GENDER_CODE));
        String idCard17 = code + birthday + seq + genderCode;
        char checkCode = IdCards.getCheckCode18((String)idCard17);
        return idCard17 + checkCode;
    }

    public static String getIssueOrg(String idCard) {
        String county = idCard.substring(0, 6);
        return AddressSupport.getSupportCountyName(Integer.parseInt(county)) + PSB;
    }

    public static String getAddress(String idCard) {
        String county = idCard.substring(0, 6);
        return AddressSupport.getCountyAddress(AddressSupport.getSupportCountyCode(Integer.parseInt(county)));
    }

    public static String getFullAddress(String idCard) {
        String county = idCard.substring(0, 6);
        Integer countyCode = AddressSupport.getSupportCountyCode(Integer.parseInt(county));
        return AddressSupport.getCountyAddress(countyCode) + AddressGenerator.generatorIdCardAddress();
    }

    public static Integer getAddressCode(String idCard) {
        return Integer.valueOf(idCard.substring(0, 6));
    }

    public static Integer[] getAddressCodeExt(String idCard) {
        String province = idCard.substring(0, 2);
        String city = idCard.substring(0, 4);
        String county = idCard.substring(0, 6);
        return new Integer[]{Integer.valueOf(province), Integer.valueOf(city), Integer.valueOf(county)};
    }

    public static String[] getAddressExt(String idCard) {
        return AddressSupport.getAddressExt(IdCardGenerator.getAddressCode(idCard));
    }

    public static String getPeriodString(String idCard) {
        Date[] dates = IdCardGenerator.getPeriod(idCard);
        return Dates.format((Date)dates[0], (String)"yyyyMMdd") + "-" + Dates.format((Date)dates[1], (String)"yyyyMMdd");
    }

    public static Date[] getPeriod(String idCard) {
        int age = IdCards.getAge((String)idCard);
        int periodYear = age <= 16 ? 5 : (age <= 25 ? 10 : 20);
        DateStream curr = Dates.stream();
        int year = curr.getYear() - age / 8;
        int month = Randoms.randomInt((int)12) + 1;
        int day = Randoms.randomInt((int)Dates.getMonthLastDay((int)year, (int)month)) + 1;
        DateStream period = Dates.stream((Date)Dates.build((int)year, (int)month, (int)day));
        Date start = period.date();
        Date end = period.addYear(periodYear).date();
        return new Date[]{start, end};
    }
}

