/*
 * Decompiled with CFR 0.152.
 */
package com.orion.generator.faker;

import com.orion.generator.addres.AddressGenerator;
import com.orion.generator.addres.AddressSupport;
import com.orion.generator.addres.Nationalities;
import com.orion.generator.bank.BankCardGenerator;
import com.orion.generator.bank.BankCardType;
import com.orion.generator.bank.BankNameType;
import com.orion.generator.company.CompanyGenerator;
import com.orion.generator.education.EducationGenerator;
import com.orion.generator.education.UniversityGenerator;
import com.orion.generator.email.EmailGenerator;
import com.orion.generator.faker.FakerInfo;
import com.orion.generator.faker.FakerType;
import com.orion.generator.idcard.IdCardGenerator;
import com.orion.generator.industry.IndustryGenerator;
import com.orion.generator.mobile.MobileGenerator;
import com.orion.generator.name.EnglishNameGenerator;
import com.orion.generator.name.NameGenerator;
import com.orion.generator.plate.LicensePlateGenerator;
import com.orion.lang.define.wrapper.Pair;
import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.identity.CreditCodes;
import com.orion.lang.utils.net.IPs;
import com.orion.lang.utils.random.Randoms;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Optional;

public class Faker {
    private static final int AGE_MIN = 18;
    private static final int AGE_MAX = 50;

    private Faker() {
    }

    public static FakerInfo generator(FakerType ... types) {
        return Faker.generator(AGE_MIN, AGE_MAX, Randoms.randomBoolean(), types);
    }

    public static FakerInfo generator(int age, FakerType ... types) {
        return Faker.generator(age, Randoms.randomBoolean(), types);
    }

    public static FakerInfo generator(boolean gender, FakerType ... types) {
        return Faker.generator(AGE_MIN, AGE_MAX, gender, types);
    }

    public static FakerInfo generator(int ageMin, int ageMax, FakerType ... types) {
        return Faker.generator(ageMin, ageMax, Randoms.randomBoolean(), types);
    }

    public static FakerInfo generator(int ageMin, int ageMax, boolean gender, FakerType ... types) {
        return Faker.generator(Randoms.randomInt((int)ageMin, (int)ageMax), gender, types);
    }

    public static FakerInfo generator(int age, boolean gender, FakerType ... types) {
        FakerInfo fakerInfo = new FakerInfo();
        fakerInfo.setAge(age);
        fakerInfo.setGender(gender);
        if (Arrays1.isEmpty((Object[])types)) {
            return fakerInfo;
        }
        Arrays.sort(types, Comparator.comparing(Enum::ordinal));
        for (FakerType type : types) {
            if (FakerType.NAME.equals((Object)type)) {
                fakerInfo.setName(NameGenerator.generatorName(gender));
                continue;
            }
            if (FakerType.EN_NAME.equals((Object)type)) {
                fakerInfo.setEnName(EnglishNameGenerator.generatorName());
                continue;
            }
            if (FakerType.MOBILE.equals((Object)type)) {
                fakerInfo.setMobile(MobileGenerator.generateMobile());
                continue;
            }
            if (FakerType.EMAIL.equals((Object)type)) {
                fakerInfo.setEmail(EmailGenerator.generatorEmail());
                continue;
            }
            if (FakerType.ADDRESS.equals((Object)type)) {
                FakerInfo.FakerAddress fakerAddress = new FakerInfo.FakerAddress();
                Faker.generatorAddressCode(fakerAddress);
                String address = AddressSupport.getCountyAddress(fakerAddress.getCountryCode());
                String detailAddress = AddressGenerator.generatorAddress();
                fakerAddress.setAddress(address);
                fakerAddress.setDetailAddress(detailAddress);
                fakerInfo.setAddress(fakerAddress);
                continue;
            }
            if (FakerType.ID_CARD.equals((Object)type)) {
                String idCard;
                if (fakerInfo.getAddress() != null && Randoms.randomBoolean()) {
                    Integer provinceCode = fakerInfo.getAddress().getProvinceCode();
                    Integer cityCode = AddressSupport.randomCityCode(provinceCode);
                    Integer countyCode = AddressSupport.randomCountyCode(cityCode);
                    idCard = IdCardGenerator.generator(countyCode.toString(), age, gender);
                } else {
                    idCard = IdCardGenerator.generator(age, gender);
                }
                String fullAddress = IdCardGenerator.getFullAddress(idCard);
                String issueOrg = IdCardGenerator.getIssueOrg(idCard);
                String periodString = IdCardGenerator.getPeriodString(idCard);
                Date[] period = IdCardGenerator.getPeriod(idCard);
                Integer[] codeExt = IdCardGenerator.getAddressCodeExt(idCard);
                String[] addressExt = IdCardGenerator.getAddressExt(idCard);
                String nation = Nationalities.getNation(codeExt[0]);
                FakerInfo.FakerIdCard fakerIdCard = new FakerInfo.FakerIdCard();
                fakerIdCard.setCardNo(idCard);
                fakerIdCard.setAddress(fullAddress);
                fakerIdCard.setIssueOrg(issueOrg);
                fakerIdCard.setPeriod(periodString);
                fakerIdCard.setPeriodStart(period[0]);
                fakerIdCard.setPeriodEnd(period[1]);
                fakerIdCard.setProvinceCode(codeExt[0]);
                fakerIdCard.setProvinceName(addressExt[0]);
                fakerIdCard.setCityCode(codeExt[1]);
                fakerIdCard.setCityName(addressExt[1]);
                fakerIdCard.setCountryCode(codeExt[2]);
                fakerIdCard.setCountryName(addressExt[2]);
                fakerIdCard.setNation(nation);
                fakerInfo.setIdCard(fakerIdCard);
                continue;
            }
            if (FakerType.DEBIT_CARD.equals((Object)type) || FakerType.CREDIT_CARD.equals((Object)type)) {
                BankCardType cardType = FakerType.DEBIT_CARD.equals((Object)type) ? BankCardType.DEBIT : BankCardType.CREDIT;
                Pair<BankNameType, String> bankPair = BankCardGenerator.generatorCard(cardType);
                FakerInfo.FakerBankCard card = new FakerInfo.FakerBankCard();
                card.setCardNo((String)bankPair.getValue());
                card.setBankCode(((BankNameType)((Object)bankPair.getKey())).getCode());
                card.setBankName(((BankNameType)((Object)bankPair.getKey())).getName());
                FakerInfo.AddressCode addressCode = Optional.ofNullable(fakerInfo.getAddress()).orElse((FakerInfo.FakerAddress)((Object)fakerInfo.getIdCard()));
                if (addressCode != null) {
                    card.setProvinceCode(addressCode.getProvinceCode());
                    card.setProvinceName(addressCode.getProvinceName());
                    card.setCityCode(addressCode.getCityCode());
                    card.setCityName(addressCode.getCityName());
                    card.setCountryCode(addressCode.getCountryCode());
                    card.setCountryName(addressCode.getCountryName());
                } else {
                    Faker.generatorAddressCode(card);
                }
                card.setIssueOrg(BankCardGenerator.generatorOpeningBank((BankNameType)((Object)bankPair.getKey()), card.getCountryCode()));
                if (FakerType.DEBIT_CARD.equals((Object)type)) {
                    fakerInfo.setDebitCard(card);
                    continue;
                }
                fakerInfo.setCreditCard(card);
                continue;
            }
            if (FakerType.EDUCATION.equals((Object)type)) {
                String education = EducationGenerator.generatorEducation(age);
                fakerInfo.setEducation(education);
                continue;
            }
            if (FakerType.UNIVERSITY.equals((Object)type)) {
                String university = Optional.ofNullable(fakerInfo.getEducation()).map(UniversityGenerator::generatorUniversity).orElseGet(UniversityGenerator::generatorUniversity);
                fakerInfo.setUniversity(university);
                continue;
            }
            if (FakerType.INDUSTRY.equals((Object)type)) {
                String industry = IndustryGenerator.generatorIndustry(age);
                fakerInfo.setIndustry(industry);
                continue;
            }
            if (FakerType.LICENSE_PLATE.equals((Object)type)) {
                int provinceCode = Faker.getProvinceCode(fakerInfo);
                String licensePlate = LicensePlateGenerator.generator(provinceCode);
                fakerInfo.setLicensePlate(licensePlate);
                continue;
            }
            if (FakerType.COMPANY_CREDIT_CODE.equals((Object)type)) {
                fakerInfo.setCompanyCreditCode(CreditCodes.random());
                continue;
            }
            if (FakerType.COMPANY_NAME.equals((Object)type)) {
                String managementType = fakerInfo.getIndustry() != null ? IndustryGenerator.generatorManagementType(fakerInfo.getIndustry()) : IndustryGenerator.generatorManagementType(age);
                int provinceCode = Faker.getProvinceCode(fakerInfo);
                fakerInfo.setCompanyName(CompanyGenerator.generatorCompanyName(provinceCode, managementType));
                continue;
            }
            if (!FakerType.IP.equals((Object)type)) continue;
            fakerInfo.setIp(IPs.randomIp());
        }
        return fakerInfo;
    }

    private static Integer getProvinceCode(FakerInfo fakerInfo) {
        return Optional.ofNullable(fakerInfo.getAddress()).map(FakerInfo.AddressCode::getProvinceCode).orElseGet(() -> Optional.ofNullable(fakerInfo.getIdCard()).map(FakerInfo.AddressCode::getProvinceCode).orElseGet(AddressSupport::randomProvinceCode));
    }

    private static void generatorAddressCode(FakerInfo.AddressCode fakerAddress) {
        Integer provinceCode = AddressSupport.randomProvinceCode();
        Integer cityCode = AddressSupport.randomCityCode(provinceCode);
        Integer countyCode = AddressSupport.randomCountyCode(cityCode);
        String[] addressExt = AddressSupport.getAddressExt(countyCode);
        fakerAddress.setProvinceName(addressExt[0]);
        fakerAddress.setCityName(addressExt[1]);
        fakerAddress.setCountryName(addressExt[2]);
        fakerAddress.setProvinceCode(provinceCode);
        fakerAddress.setCityCode(cityCode);
        fakerAddress.setCountryCode(countyCode);
    }
}

