/*
 * Decompiled with CFR 0.152.
 */
package com.orion.generator.bank;

import com.orion.generator.addres.AddressSupport;
import com.orion.generator.bank.BankCardSupport;
import com.orion.generator.bank.BankCardType;
import com.orion.generator.bank.BankNameType;
import com.orion.lang.define.wrapper.Pair;
import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.collect.Sets;
import com.orion.lang.utils.random.Randoms;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BankCardGenerator {
    private static final String BRANCH_BANK_NAME = "\u5206\u884c";
    private static final String SUBBRANCH_BANK_NAME = "\u652f\u884c";

    private BankCardGenerator() {
    }

    public static Pair<BankNameType, String> generatorCard() {
        return BankCardGenerator.generatorCard(BankCardType.DEBIT);
    }

    public static Pair<BankNameType, String> generatorCard(BankCardType card) {
        BankNameType bank = (BankNameType)((Object)Arrays1.random((Object[])BankNameType.values()));
        return Pair.of((Object)((Object)bank), (Object)BankCardGenerator.generatorCard(bank, card));
    }

    public static String generatorCard(BankNameType bank) {
        return BankCardGenerator.generatorCard(bank, BankCardType.DEBIT);
    }

    public static String generatorCard(BankNameType bank, BankCardType card) {
        Map<String, Integer> prefixMap = BankCardType.DEBIT.equals((Object)card) ? bank.getDebitPrefix() : bank.getCreditPrefix();
        Set<String> keys = prefixMap.keySet();
        String prefix = (String)Objects.requireNonNull(Sets.random(keys));
        Integer length = prefixMap.get(prefix);
        int contentLength = length - prefix.length() - 1;
        long randomMax = Long.parseLong(Strings.repeat((char)'9', (int)contentLength));
        String cardNoCheck = prefix + Strings.leftPad((String)(Randoms.randomLong((long)randomMax) + ""), (int)contentLength, (char)'0');
        char checkCode = BankCardSupport.getCheckCode(cardNoCheck.toCharArray());
        return cardNoCheck + checkCode;
    }

    public static String generatorOpeningBank(BankNameType bank) {
        return BankCardGenerator.generatorOpeningBank(bank, AddressSupport.randomCountyCode());
    }

    public static String generatorOpeningBank(BankNameType bank, Integer countyCode) {
        int cityCode = Integer.parseInt(countyCode.toString().substring(0, 4));
        String cityName = AddressSupport.getCityName(cityCode);
        String countyName = AddressSupport.getCountyName(countyCode);
        return bank.getName() + cityName + BRANCH_BANK_NAME + countyName + SUBBRANCH_BANK_NAME;
    }
}

