/*
 * Decompiled with CFR 0.152.
 */
package com.orion.generator.addres;

import com.orion.generator.addres.AddressArea;
import com.orion.lang.define.builder.StringJoiner;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;

public class AddressSupport {
    private AddressSupport() {
    }

    public static Integer randomProvinceCode() {
        return (Integer)AddressArea.POPULATION.next();
    }

    public static Integer randomCityCode() {
        return AddressSupport.randomCityCode(AddressSupport.randomProvinceCode());
    }

    public static Integer randomCityCode(int provinceCode) {
        List cities = AddressArea.CITY.keySet().stream().filter(c -> c.toString().startsWith(provinceCode + "")).collect(Collectors.toList());
        return (Integer)Lists.random(cities);
    }

    public static Integer randomCountyCode() {
        return AddressSupport.randomCountyCode(AddressSupport.randomCityCode());
    }

    public static Integer randomCountyCode(int cityCode) {
        List counties = AddressArea.COUNTY.keySet().stream().filter(c -> c.toString().startsWith(cityCode + "")).collect(Collectors.toList());
        return (Integer)Lists.random(counties);
    }

    public static String getProvinceName(int provinceCode) {
        return AddressArea.PROVINCE.get(provinceCode);
    }

    public static String getCityName(int cityCode) {
        return AddressArea.CITY.get(cityCode);
    }

    public static String getCountyName(int countyCode) {
        return AddressArea.COUNTY.get(countyCode);
    }

    public static String getSupportCountyName(int countyCode) {
        return AddressArea.COUNTY.get(AddressSupport.getSupportCountyCode(countyCode));
    }

    public static Integer getSupportCountyCode(int countyCode) {
        String county = AddressArea.COUNTY.get(countyCode);
        if (county != null) {
            return countyCode;
        }
        String city = (countyCode + "").substring(0, 4);
        Integer randomCountyCode = AddressSupport.randomCountyCode(Integer.parseInt(city));
        if (randomCountyCode != null) {
            return randomCountyCode;
        }
        String province = city.substring(0, 2);
        Integer randomCityCode = AddressSupport.randomCityCode(Integer.parseInt(province));
        if (randomCityCode == null) {
            return 0;
        }
        return AddressSupport.randomCountyCode(randomCityCode);
    }

    public static String randomCountyAddress() {
        return AddressSupport.getCountyAddress(AddressSupport.randomCountyCode());
    }

    public static String[] randomAddressExt() {
        return AddressSupport.getAddressExt(AddressSupport.randomCountyCode());
    }

    public static String[] getAddressExt(int countyCode) {
        String city = (countyCode + "").substring(0, 4);
        String province = city.substring(0, 2);
        return new String[]{Strings.def((String)AddressArea.PROVINCE.get(Integer.parseInt(province))), Strings.def((String)AddressArea.CITY.get(Integer.parseInt(city))), Strings.def((String)AddressArea.COUNTY.get(countyCode))};
    }

    public static String getCountyAddress(int countyCode) {
        String cityCode = (countyCode + "").substring(0, 4);
        String provinceCode = cityCode.substring(0, 2);
        String province = AddressArea.PROVINCE.get(Integer.parseInt(provinceCode));
        String city = AddressArea.CITY.get(Integer.parseInt(cityCode));
        String county = AddressArea.COUNTY.get(countyCode);
        return StringJoiner.of().with(province).with(city).with(county).skipBlank().build();
    }
}

