/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.tail.delay;

import com.orion.ext.tail.Tracker;
import com.orion.ext.tail.mode.FileMinusMode;
import com.orion.ext.tail.mode.FileNotFoundMode;
import com.orion.ext.tail.mode.FileOffsetMode;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Threads;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.FileReaders;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class AbstractDelayTracker
extends Tracker {
    protected File tailFile;
    protected RandomAccessFile reader;
    protected String charset;
    protected int delayMillis;
    protected FileOffsetMode fileOffsetMode;
    protected long offset;
    protected FileNotFoundMode notFoundMode;
    protected int notFountTimes;
    protected FileMinusMode minusMode;

    public AbstractDelayTracker(String tailFile) {
        this(new File(tailFile));
    }

    public AbstractDelayTracker(File tailFile) {
        Valid.notNull((Object)tailFile, (String)"tail file is null", (Object[])new Object[0]);
        this.tailFile = tailFile;
        this.charset = "UTF-8";
        this.offset = -1L;
        this.delayMillis = 1000;
        this.fileOffsetMode = FileOffsetMode.BYTE;
        this.notFoundMode = FileNotFoundMode.CLOSE;
        this.minusMode = FileMinusMode.CURRENT;
    }

    @Override
    public void tail() {
        try {
            if (!this.init()) {
                return;
            }
            this.run = true;
            this.setSeek();
            long lastMod = 0L;
            long lastLen = this.tailFile.length();
            while (this.run) {
                if (this.tailFile.lastModified() > lastMod) {
                    long length = this.tailFile.length();
                    if (lastLen > length && this.reader.getFilePointer() >= length) {
                        this.resetSeek();
                    }
                    this.read();
                }
                lastMod = this.tailFile.lastModified();
                lastLen = this.tailFile.length();
                Threads.sleep((long)this.delayMillis);
            }
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
        finally {
            Streams.close((AutoCloseable)this.reader);
            this.reader = null;
        }
    }

    protected boolean init() throws IOException {
        if (Files1.isFile((File)this.tailFile)) {
            this.reader = Files1.openRandomAccess((File)this.tailFile, (String)"r");
            return true;
        }
        switch (this.notFoundMode) {
            case WAIT: {
                this.run = true;
                while (this.run) {
                    Threads.sleep((long)this.delayMillis);
                    if (!Files1.isFile((File)this.tailFile)) continue;
                    this.reader = Files1.openRandomAccess((File)this.tailFile, (String)"r");
                    return true;
                }
                this.run = false;
                return false;
            }
            case WAIT_TIMES: {
                int fi = 1;
                int fd = this.notFountTimes;
                int last = this.notFountTimes;
                if (this.notFountTimes > this.delayMillis) {
                    long s = this.notFountTimes / this.delayMillis;
                    long m = this.notFountTimes % this.delayMillis;
                    fd = this.delayMillis;
                    if (m == 0L) {
                        last = this.delayMillis;
                        fi = (int)s;
                    } else {
                        last = (int)m;
                        fi += (int)s;
                    }
                }
                for (int i = 0; i < fi; ++i) {
                    if (i == fi - 1) {
                        Threads.sleep((long)last);
                    } else {
                        Threads.sleep((long)fd);
                    }
                    if (!this.run || !Files1.isFile((File)this.tailFile)) continue;
                    this.reader = Files1.openRandomAccess((File)this.tailFile, (String)"r");
                    return true;
                }
                return false;
            }
            case WAIT_COUNT: {
                for (int i = 0; i < this.notFountTimes; ++i) {
                    Threads.sleep((long)this.delayMillis);
                    if (!this.run || !Files1.isFile((File)this.tailFile)) continue;
                    this.reader = Files1.openRandomAccess((File)this.tailFile, (String)"r");
                    return true;
                }
                return false;
            }
            case THROWS: {
                throw Exceptions.notFound((String)Strings.format((String)"tail file {} not found", (Object[])new Object[]{this.tailFile.getAbsolutePath()}));
            }
        }
        return false;
    }

    protected void setSeek() throws IOException {
        long length = this.tailFile.length();
        if (this.offset == -1L) {
            this.reader.seek(length);
        } else if (this.offset == 0L) {
            this.reader.seek(0L);
        } else if (this.offset > 0L) {
            long pos = 0L;
            if (this.fileOffsetMode == FileOffsetMode.BYTE) {
                pos = length - this.offset;
            } else if (this.fileOffsetMode == FileOffsetMode.LINE) {
                pos = FileReaders.readTailLinesSeek((RandomAccessFile)this.reader, (int)((int)this.offset));
            }
            if (pos >= 0L) {
                this.reader.seek(pos);
            }
        }
    }

    protected void resetSeek() throws IOException {
        switch (this.minusMode) {
            case CLOSE: {
                this.run = false;
                return;
            }
            case CURRENT: {
                this.reader.seek(this.tailFile.length());
                return;
            }
            case OFFSET: {
                this.setSeek();
                return;
            }
            case RESUME: {
                this.reader.seek(0L);
                return;
            }
            case THROWS: {
                throw Exceptions.state((String)Strings.format((String)"tail file {} minus", (Object[])new Object[]{this.tailFile.getAbsolutePath()}));
            }
        }
    }

    protected abstract void read() throws IOException;

    public boolean setFileLastModifyTime() {
        return this.tailFile.setLastModified(System.currentTimeMillis());
    }

    public AbstractDelayTracker charset(String charset) {
        this.charset = charset;
        return this;
    }

    public AbstractDelayTracker offset(long offset) {
        this.offset = offset;
        return this;
    }

    public AbstractDelayTracker offset(FileOffsetMode fileOffsetMode, long offset) {
        this.fileOffsetMode = fileOffsetMode;
        this.offset = offset;
        return this;
    }

    public AbstractDelayTracker delayMillis(int delayMillis) {
        this.delayMillis = delayMillis;
        return this;
    }

    public AbstractDelayTracker notFoundMode(FileNotFoundMode notFoundMode) {
        return this.notFoundMode(notFoundMode, 0);
    }

    public AbstractDelayTracker notFoundMode(FileNotFoundMode notFoundMode, int notFountTimes) {
        this.notFoundMode = notFoundMode;
        this.notFountTimes = notFountTimes;
        if (notFoundMode == FileNotFoundMode.WAIT_TIMES || notFoundMode == FileNotFoundMode.WAIT_COUNT) {
            Valid.gte((Comparable)Integer.valueOf(notFountTimes), (Comparable)Integer.valueOf(0), (String)"not fount times has to be greater than or equal to 0", (Object[])new Object[0]);
        }
        return this;
    }

    public AbstractDelayTracker minusMode(FileMinusMode minusMode) {
        this.minusMode = minusMode;
        return this;
    }

    public void close() {
        Streams.close((AutoCloseable)this.reader);
    }

    public String toString() {
        return this.tailFile.toString();
    }
}

