/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.process;

import com.orion.ext.process.BaseProcessExecutor;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.io.Files1;
import java.io.File;

public class ProcessAsyncExecutor
extends BaseProcessExecutor {
    private ProcessBuilder pb;
    private Process process;
    private File inputFile;
    private File outputFile;
    private File errorFile;
    private boolean outAppend;
    private boolean errAppend;

    public ProcessAsyncExecutor(String command) {
        this(new String[]{command}, null);
    }

    public ProcessAsyncExecutor(String[] command) {
        this(command, null);
    }

    public ProcessAsyncExecutor(String command, String dir) {
        this(new String[]{command}, dir);
    }

    public ProcessAsyncExecutor(String[] command, String dir) {
        super(command, dir);
    }

    public ProcessAsyncExecutor inputFile(String inputFile) {
        this.inputFile = new File(inputFile);
        return this;
    }

    public ProcessAsyncExecutor inputFile(File inputFile) {
        this.inputFile = inputFile;
        return this;
    }

    public ProcessAsyncExecutor errorFile(String errorFile) {
        this.errorFile = new File(errorFile);
        return this;
    }

    public ProcessAsyncExecutor errorFile(File errorFile) {
        this.errorFile = errorFile;
        return this;
    }

    public ProcessAsyncExecutor errorFile(String errorFile, boolean append) {
        this.errorFile = new File(errorFile);
        this.errAppend = append;
        return this;
    }

    public ProcessAsyncExecutor errorFile(File errorFile, boolean append) {
        this.errorFile = errorFile;
        this.errAppend = append;
        return this;
    }

    public ProcessAsyncExecutor outputFile(String outputFile) {
        this.outputFile = new File(outputFile);
        return this;
    }

    public ProcessAsyncExecutor outputFile(File outputFile) {
        this.outputFile = outputFile;
        return this;
    }

    public ProcessAsyncExecutor outputFile(String outputFile, boolean append) {
        this.outputFile = new File(outputFile);
        this.outAppend = append;
        return this;
    }

    public ProcessAsyncExecutor outputFile(File outputFile, boolean append) {
        this.outputFile = outputFile;
        this.outAppend = append;
        return this;
    }

    public void exec() {
        try {
            this.pb = new ProcessBuilder(this.command);
            this.env = this.pb.environment();
            if (this.removeEnv != null) {
                for (String key : this.removeEnv) {
                    this.env.remove(key);
                }
            }
            if (this.addEnv != null) {
                this.env.putAll(this.addEnv);
            }
            this.pb.directory(this.dir == null ? null : new File(this.dir));
            this.pb.redirectErrorStream(this.redirectError);
            if (this.inputFile != null) {
                Files1.touch((File)this.inputFile);
                this.pb.redirectInput(this.inputFile);
            } else {
                this.pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
            }
            if (!this.redirectError) {
                if (this.errorFile != null) {
                    Files1.touch((File)this.errorFile);
                    if (this.errAppend) {
                        this.pb.redirectError(ProcessBuilder.Redirect.appendTo(this.errorFile));
                    } else {
                        this.pb.redirectError(ProcessBuilder.Redirect.to(this.errorFile));
                    }
                } else {
                    this.pb.redirectError(ProcessBuilder.Redirect.INHERIT);
                }
            }
            if (this.outputFile != null) {
                Files1.touch((File)this.outputFile);
                if (this.outAppend) {
                    this.pb.redirectOutput(ProcessBuilder.Redirect.appendTo(this.outputFile));
                } else {
                    this.pb.redirectOutput(ProcessBuilder.Redirect.to(this.outputFile));
                }
            } else {
                this.pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            }
            this.process = this.pb.start();
        }
        catch (Exception e) {
            throw Exceptions.runtime((Throwable)e);
        }
    }

    @Override
    public void close() {
        this.process.destroy();
    }

    @Override
    public boolean isAlive() {
        return this.process.isAlive();
    }

    @Override
    public int getExitCode() {
        if (!this.process.isAlive()) {
            return this.process.exitValue();
        }
        return -1;
    }

    @Override
    public ProcessBuilder getProcessBuilder() {
        return this.pb;
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public File getErrorFile() {
        return this.errorFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }
}

