/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.mail;

import com.orion.ext.mail.MailAttachment;
import com.orion.ext.mail.MailMessage;
import com.orion.ext.mail.MailServerProvider;
import com.orion.lang.able.ISendEvent;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailSender
implements ISendEvent<MailMessage> {
    private final Properties props = new Properties();
    private boolean debug;
    private PasswordAuthentication authentication;

    public MailSender(MailServerProvider type) {
        this(type.getHost(), type.getPort());
    }

    public MailSender(String serverHost, int serverPort) {
        this.props.put("mail.transport.protocol", "smtp");
        this.props.put("mail.smtp.auth", "true");
        this.props.put("mail.smtp.host", serverHost);
        this.props.put("mail.smtp.port", serverPort + "");
        this.props.put("mail.smtp.socketFactory.port", serverPort + "");
        this.props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        this.props.put("mail.smtp.socketFactory.fallback", "false");
        this.props.put("mail.smtp.ssl.enable", (Object)false);
    }

    public MailSender ssl() {
        this.props.put("mail.smtp.ssl.enable", (Object)true);
        return this;
    }

    public MailSender ssl(int sslPort) {
        this.props.put("mail.smtp.ssl.enable", (Object)true);
        this.props.put("mail.smtp.port", sslPort + "");
        this.props.put("mail.smtp.socketFactory.port", sslPort + "");
        return this;
    }

    public MailSender debug() {
        this.debug = true;
        return this;
    }

    public MailSender auth(String serverUsername, String serverPassword) {
        this.authentication = new PasswordAuthentication(serverUsername, serverPassword);
        return this;
    }

    public void send(MailMessage msg) {
        Valid.notNull((Object)this.authentication, (String)"sender service unauthorized", (Object[])new Object[0]);
        Session session = Session.getDefaultInstance((Properties)this.props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return MailSender.this.authentication;
            }
        });
        session.setDebug(this.debug);
        try {
            List<String> bcc;
            List<String> cc;
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(msg.getFrom()));
            List<String> to = msg.getTo();
            if (to != null && !to.isEmpty()) {
                InternetAddress[] ccAddress = new InternetAddress[to.size()];
                int size = to.size();
                for (int i = 0; i < size; ++i) {
                    ccAddress[i] = new InternetAddress(to.get(i));
                }
                mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])ccAddress);
            }
            if ((cc = msg.getCc()) != null && !cc.isEmpty()) {
                InternetAddress[] ccAddress = new InternetAddress[cc.size()];
                int size = cc.size();
                for (int i = 0; i < size; ++i) {
                    ccAddress[i] = new InternetAddress(cc.get(i));
                }
                mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])ccAddress);
            }
            if ((bcc = msg.getBcc()) != null && !bcc.isEmpty()) {
                InternetAddress[] bccAddress = new InternetAddress[bcc.size()];
                int size = bcc.size();
                for (int i = 0; i < size; ++i) {
                    bccAddress[i] = new InternetAddress(bcc.get(i));
                }
                mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])bccAddress);
            }
            mimeMessage.setSubject(msg.getTitle(), msg.getContentCharset());
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart body = new MimeBodyPart();
            body.setContent((Object)msg.getContent(), msg.getMimeType() + ";charset=" + msg.getContentCharset());
            multipart.addBodyPart((BodyPart)body);
            if (msg.getAttachments() != null && !msg.getAttachments().isEmpty()) {
                for (MailAttachment attachment : msg.getAttachments()) {
                    multipart.addBodyPart((BodyPart)attachment.getMimeBodyPart());
                }
            }
            mimeMessage.setContent((Multipart)multipart);
            mimeMessage.setSentDate(new Date());
            Transport.send((Message)mimeMessage);
        }
        catch (Exception e) {
            throw Exceptions.runtime((Throwable)e);
        }
    }

    public Properties getProps() {
        return this.props;
    }
}

