/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.mail;

import com.orion.ext.mail.MailAttachment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MailMessage
implements Serializable {
    private String from;
    private List<String> to;
    private List<String> cc;
    private List<String> bcc;
    private String title;
    private String content;
    private String mimeType = "text/plain";
    private String contentCharset = "UTF-8";
    private List<MailAttachment> attachments;

    public MailMessage message(String from, String title, String content) {
        this.from = from;
        this.title = title;
        this.content = content;
        return this;
    }

    public MailMessage message(String from, String to, String title, String content) {
        this.from = from;
        this.title = title;
        this.content = content;
        return this.to(to);
    }

    public MailMessage message(String from, String to, String title, String content, String mimeType) {
        this.from = from;
        this.title = title;
        this.content = content;
        this.mimeType = mimeType;
        return this.to(to);
    }

    public MailMessage from(String from) {
        this.from = from;
        return this;
    }

    public MailMessage to(String ... to) {
        if (this.to == null) {
            this.to = new ArrayList<String>();
        }
        this.to.addAll(Arrays.asList(to));
        return this;
    }

    public MailMessage to(Collection<String> to) {
        if (this.to == null) {
            this.to = new ArrayList<String>();
        }
        this.to.addAll(to);
        return this;
    }

    public MailMessage cc(String ... cc) {
        if (this.cc == null) {
            this.cc = new ArrayList<String>();
        }
        this.cc.addAll(Arrays.asList(cc));
        return this;
    }

    public MailMessage cc(Collection<String> cc) {
        if (this.cc == null) {
            this.cc = new ArrayList<String>();
        }
        this.cc.addAll(cc);
        return this;
    }

    public MailMessage bcc(String ... bcc) {
        if (this.bcc == null) {
            this.bcc = new ArrayList<String>();
        }
        this.bcc.addAll(Arrays.asList(bcc));
        return this;
    }

    public MailMessage bcc(Collection<String> bcc) {
        if (this.bcc == null) {
            this.bcc = new ArrayList<String>();
        }
        this.bcc.addAll(bcc);
        return this;
    }

    public MailMessage title(String title) {
        this.title = title;
        return this;
    }

    public MailMessage content(String content) {
        this.content = content;
        return this;
    }

    public MailMessage addLine(String line) {
        this.content = this.content == null ? line : this.content + line + this.newLine();
        return this;
    }

    public MailMessage addLines(String ... lines) {
        StringBuilder sb = new StringBuilder(this.content == null ? "" : this.content);
        for (String line : lines) {
            sb.append(line).append(this.newLine());
        }
        this.content = sb.toString();
        return this;
    }

    public MailMessage addLines(Collection<String> lines) {
        StringBuilder sb = new StringBuilder(this.content == null ? "" : this.content);
        for (String line : lines) {
            sb.append(line).append(this.newLine());
        }
        this.content = sb.toString();
        return this;
    }

    public MailMessage mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public MailMessage html() {
        this.mimeType = "text/html";
        return this;
    }

    public MailMessage text() {
        this.mimeType = "text/plain";
        return this;
    }

    public MailMessage contentCharset(String contentCharset) {
        this.contentCharset = contentCharset;
        return this;
    }

    public MailMessage attachment(MailAttachment attachment) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<MailAttachment>();
        }
        this.attachments.add(attachment);
        return this;
    }

    public MailMessage attachments(Collection<MailAttachment> attachments) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<MailAttachment>();
        }
        this.attachments.addAll(attachments);
        return this;
    }

    private String newLine() {
        return "text/html".equals(this.mimeType) ? "<br/>" : "\n";
    }

    public String getFrom() {
        return this.from;
    }

    public List<String> getTo() {
        return this.to;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getContentCharset() {
        return this.contentCharset;
    }

    public List<MailAttachment> getAttachments() {
        return this.attachments;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EMAIL: form: [");
        sb.append(this.from).append("]").append('\n');
        sb.append("  ==>    to: ").append(this.to == null ? "[]" : this.to.toString()).append(" ").append('\n');
        if (this.cc != null) {
            sb.append("  ==>    cc: ").append(this.cc).append(" ").append('\n');
        }
        if (this.bcc != null) {
            sb.append("  ==>   bcc: ").append(this.bcc).append(" ").append('\n');
        }
        sb.append("  ==> title: [").append(this.title).append("] ").append('\n');
        return sb.toString();
    }
}

