/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.location.region;

import com.orion.ext.location.Region;
import com.orion.ext.location.region.block.DataBlock;
import com.orion.ext.location.region.config.DbConfig;
import com.orion.ext.location.region.core.DbSearcher;
import com.orion.lang.define.builder.StringJoiner;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Systems;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.net.IPs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class LocationRegions {
    private static final String UNKNOWN;
    private static final String DB_PATH;
    private static final DbSearcher SEARCHER;

    private LocationRegions() {
    }

    public static Region getRegion(String ip) {
        return LocationRegions.getRegion(ip, 1);
    }

    public static Region getRegion(String ip, int algorithm) {
        String s = LocationRegions.getAddress(ip, algorithm);
        if (s == null) {
            return null;
        }
        String[] rs = s.split("\\|");
        return new Region(rs[0], rs[1], rs[2], rs[3], rs[4]);
    }

    public static String getAddress(String ip) {
        return LocationRegions.getAddress(ip, 1);
    }

    public static String getAddress(String ip, int algorithm) {
        try {
            DataBlock dataBlock;
            if (!IPs.isIpv4((String)ip)) {
                return UNKNOWN;
            }
            switch (algorithm) {
                case 2: {
                    dataBlock = SEARCHER.binarySearch(ip);
                    break;
                }
                case 3: {
                    dataBlock = SEARCHER.memorySearch(ip);
                    break;
                }
                default: {
                    dataBlock = SEARCHER.btreeSearch(ip);
                }
            }
            if (dataBlock != null) {
                return dataBlock.getRegion();
            }
            return UNKNOWN;
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)Strings.format((String)"address query error ip: {}, algorithm: {}", (Object[])new Object[]{ip, algorithm}), (Throwable)e);
        }
    }

    static {
        boolean init;
        UNKNOWN = new Region().toString();
        DB_PATH = StringJoiner.of((String)Systems.FILE_SEPARATOR).with(Systems.HOME_DIR).with(".orion").with(".region").with(".region.db").build();
        try {
            InputStream source = LocationRegions.class.getClassLoader().getResourceAsStream("region.db");
            init = Files1.resourceToFile((InputStream)source, (File)new File(DB_PATH), (String)"GBK");
            SEARCHER = new DbSearcher(new DbConfig(), DB_PATH);
        }
        catch (IOException e) {
            throw Exceptions.init((String)"location region \u670d\u52a1\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
        }
        if (!init) {
            throw Exceptions.init((String)"location region \u670d\u52a1\u521d\u59cb\u5316\u5931\u8d25");
        }
    }
}

