/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model.definitions;

import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class ExtendedDefinition<T extends NamedNode<T>, E extends T> {
    protected T definition;
    protected List<E> extensions = new ArrayList();

    public String getName() {
        if (this.definition != null) {
            return this.definition.getName();
        }
        return this.extensions.stream().map(NamedNode::getName).findFirst().orElse(null);
    }

    public SourceLocation getSourceLocation() {
        if (this.definition != null) {
            return this.definition.getSourceLocation();
        }
        return this.extensions.stream().map(Node::getSourceLocation).findFirst().orElse(null);
    }

    public List<String> getDirectiveNames() {
        return this.getDirectives().stream().map(Directive::getName).collect(Collectors.toList());
    }

    public List<Directive> getDirectives() {
        ArrayList<Directive> directives = new ArrayList<Directive>();
        if (this.definition instanceof DirectivesContainer) {
            List definitionDirectives = ((DirectivesContainer)this.definition).getDirectives();
            if (!Utils.isEmpty(definitionDirectives)) {
                directives.addAll(definitionDirectives);
            }
            this.extensions.stream().filter(Objects::nonNull).map(DirectivesContainer.class::cast).map(DirectivesContainer::getDirectives).filter(dc -> !Utils.isEmpty(dc)).forEach(directives::addAll);
        }
        return directives;
    }

    public T getDefinition() {
        return this.definition;
    }

    public void setDefinition(T definition) {
        this.definition = definition;
    }

    public List<E> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<E> extensions) {
        this.extensions = extensions;
    }
}

