/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import java.util.List;
import java.util.StringJoiner;

public interface ValueFormatter {
    public static final String FORMATTER_TO_STRING = "?toString";
    public static final String FORMATTER_TO_ARRAY = "?toArray";
    public static final String FORMATTER_TO_ARRAY_OF_STRINGS = "?toArrayOfStrings";

    public static String format(String value, String formatter) {
        return FORMATTER_TO_STRING.equals(formatter) ? "\"" + value + "\"" : value;
    }

    default public String formatList(List<String> values, String formatter) {
        if (values == null) {
            return ValueFormatter.format(this.getNullValue(), formatter);
        }
        if (formatter == null) {
            if (values.isEmpty()) {
                return this.getEmptyListValue();
            }
            StringJoiner listJoiner = this.getListJoiner();
            values.forEach(listJoiner::add);
            return listJoiner.toString();
        }
        switch (formatter) {
            case "?toArrayOfStrings": {
                StringJoiner arrayOfStringsJoiner = this.getArrayJoiner();
                values.forEach(newElement -> arrayOfStringsJoiner.add(ValueFormatter.format(newElement, FORMATTER_TO_STRING)));
                return arrayOfStringsJoiner.toString();
            }
        }
        StringJoiner arrayJoiner = this.getArrayJoiner();
        values.forEach(arrayJoiner::add);
        return arrayJoiner.toString();
    }

    default public String getNullValue() {
        return "null";
    }

    public String getEmptyListValue();

    public StringJoiner getListJoiner();

    public StringJoiner getArrayJoiner();
}

