/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.generators.impl;

import com.kobylynskyi.graphql.codegen.generators.FilesGenerator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateFilesCreator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateType;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.EnumDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedEnumTypeDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EnumsGenerator
implements FilesGenerator {
    private final MappingContext mappingContext;
    private final EnumDefinitionToDataModelMapper enumDefinitionMapper;

    public EnumsGenerator(MappingContext mappingContext, DataModelMapperFactory dataModelMapperFactory) {
        this.mappingContext = mappingContext;
        this.enumDefinitionMapper = dataModelMapperFactory.getEnumDefinitionMapper();
    }

    @Override
    public List<File> generate() {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedEnumTypeDefinition definition : this.mappingContext.getDocument().getEnumDefinitions()) {
            generatedFiles.add(this.generate(definition));
        }
        return generatedFiles;
    }

    private File generate(ExtendedEnumTypeDefinition definition) {
        Map<String, Object> dataModel = this.enumDefinitionMapper.map(this.mappingContext, definition);
        return FreeMarkerTemplateFilesCreator.create(this.mappingContext, FreeMarkerTemplateType.ENUM, dataModel);
    }
}

