/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.generators;

import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateType;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplatesRegistry;
import com.kobylynskyi.graphql.codegen.model.GeneratedLanguage;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.exception.UnableToCreateFileException;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.util.Map;

public class FreeMarkerTemplateFilesCreator {
    private FreeMarkerTemplateFilesCreator() {
    }

    public static File create(MappingContext mappingContext, FreeMarkerTemplateType templateType, Map<String, Object> dataModel) {
        GeneratedLanguage language = mappingContext.getGeneratedLanguage();
        String fileName = dataModel.get("className") + language.getFileExtension();
        File fileOutputDir = FreeMarkerTemplateFilesCreator.getFileTargetDirectory(dataModel, mappingContext.getOutputDirectory());
        File javaSourceFile = new File(fileOutputDir, fileName);
        try {
            if (!javaSourceFile.createNewFile()) {
                throw new FileAlreadyExistsException("File already exists: " + javaSourceFile.getPath());
            }
        }
        catch (IOException e) {
            throw new UnableToCreateFileException(e);
        }
        try (FileWriter fileWriter = new FileWriter(javaSourceFile);){
            Template template = FreeMarkerTemplateFilesCreator.getTemplateForTypeAndLanguage(mappingContext, templateType, language);
            template.process(dataModel, (Writer)fileWriter);
        }
        catch (Exception e) {
            throw new UnableToCreateFileException(e);
        }
        return javaSourceFile;
    }

    private static Template getTemplateForTypeAndLanguage(MappingContext mappingContext, FreeMarkerTemplateType templateType, GeneratedLanguage language) {
        String templatePath = null;
        if (mappingContext.getCustomTemplates() != null) {
            templatePath = mappingContext.getCustomTemplates().get(templateType.name());
        }
        if (templatePath != null) {
            return FreeMarkerTemplatesRegistry.getCustomTemplate(mappingContext.getCustomTemplatesRoot(), templatePath);
        }
        return FreeMarkerTemplatesRegistry.getTemplateWithLang(language, templateType);
    }

    private static File getFileTargetDirectory(Map<String, Object> dataModel, File outputDir) {
        Object packageName = dataModel.get("package");
        File targetDir = packageName != null && Utils.isNotBlank(packageName.toString()) ? new File(outputDir, packageName.toString().replace(".", File.separator)) : outputDir;
        Utils.createDirIfAbsent(targetDir);
        return targetDir;
    }
}

