/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.supplier;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.supplier.MappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.io.File;
import java.util.List;

public class MergeableMappingConfigSupplier
implements MappingConfigSupplier {
    private static final ConfigRenderOptions configRenderOptions = ConfigRenderOptions.concise();
    private final String jsonConfig;

    public MergeableMappingConfigSupplier(List<String> configFiles) {
        this.jsonConfig = MergeableMappingConfigSupplier.parseConfigAndMerged(configFiles);
    }

    private static String parseConfigAndMerged(List<String> confFiles) {
        try {
            if (confFiles == null || confFiles.isEmpty()) {
                return null;
            }
            return confFiles.stream().map(c -> ConfigFactory.parseFile((File)new File((String)c))).reduce(Config::withFallback).map(value -> value.root().render(configRenderOptions)).orElse(null);
        }
        catch (ConfigException ce) {
            return null;
        }
    }

    @Override
    public MappingConfig get() {
        if (this.jsonConfig != null && !this.jsonConfig.isEmpty()) {
            try {
                return (MappingConfig)Utils.OBJECT_MAPPER.readValue(this.jsonConfig, MappingConfig.class);
            }
            catch (JsonProcessingException | ConfigException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }
}

