/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model.definitions;

import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedImplementingTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.Node;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ExtendedObjectTypeDefinition
extends ExtendedImplementingTypeDefinition<ObjectTypeDefinition, ObjectTypeExtensionDefinition> {
    private static String getSourceLocationName(Node<?> node) {
        return node.getSourceLocation() != null ? node.getSourceLocation().getSourceName() : "unknown";
    }

    public List<ExtendedFieldDefinition> getFieldDefinitions() {
        ArrayList<ExtendedFieldDefinition> definitions = new ArrayList<ExtendedFieldDefinition>();
        if (this.definition != null) {
            ((ObjectTypeDefinition)this.definition).getFieldDefinitions().stream().map(f -> new ExtendedFieldDefinition((FieldDefinition)f, false)).forEach(definitions::add);
        }
        this.extensions.stream().map(ObjectTypeDefinition::getFieldDefinitions).flatMap(Collection::stream).map(f -> new ExtendedFieldDefinition((FieldDefinition)f, true)).forEach(definitions::add);
        return definitions;
    }

    public Map<String, ExtendedObjectTypeDefinition> groupBySourceLocationFile() {
        return this.groupBySourceLocation(File::getName);
    }

    public Map<String, ExtendedObjectTypeDefinition> groupBySourceLocationFolder() {
        return this.groupBySourceLocation(File::getParent);
    }

    private Map<String, ExtendedObjectTypeDefinition> groupBySourceLocation(Function<File, String> fileStringFunction) {
        HashMap<String, ExtendedObjectTypeDefinition> definitionMap = new HashMap<String, ExtendedObjectTypeDefinition>();
        if (this.definition != null) {
            File file = new File(ExtendedObjectTypeDefinition.getSourceLocationName(this.definition));
            definitionMap.computeIfAbsent(fileStringFunction.apply(file), d -> new ExtendedObjectTypeDefinition()).setDefinition(this.definition);
        }
        for (ObjectTypeExtensionDefinition extension : this.extensions) {
            File file = new File(ExtendedObjectTypeDefinition.getSourceLocationName(extension));
            definitionMap.computeIfAbsent(fileStringFunction.apply(file), d -> new ExtendedObjectTypeDefinition()).getExtensions().add(extension);
        }
        return definitionMap;
    }
}

