/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model.builders;

import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.AbstractDescribedNode;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.NamedNode;
import graphql.language.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class JavaDocBuilder {
    private JavaDocBuilder() {
    }

    public static <T extends NamedNode<T>, E extends T> List<String> build(ExtendedDefinition<T, E> extendedDefinition) {
        List<String> javaDocFromDescription = JavaDocBuilder.buildFromDescription(extendedDefinition);
        if (javaDocFromDescription.isEmpty()) {
            return JavaDocBuilder.buildFromComments(extendedDefinition);
        }
        return javaDocFromDescription;
    }

    public static <T extends NamedNode<T>, E extends T> List<String> buildFromDescription(ExtendedDefinition<T, E> extendedDefinition) {
        T definition = extendedDefinition.getDefinition();
        List<E> extensions = extendedDefinition.getExtensions();
        ArrayList<String> descriptions = new ArrayList<String>();
        if (definition instanceof AbstractDescribedNode) {
            Description description = ((AbstractDescribedNode)definition).getDescription();
            if (description != null && Utils.isNotBlank(description.getContent())) {
                descriptions.add(description.getContent().trim());
            }
            extensions.stream().filter(Objects::nonNull).map(AbstractDescribedNode.class::cast).map(AbstractDescribedNode::getDescription).filter(Objects::nonNull).map(Description::getContent).filter(Utils::isNotBlank).map(String::trim).forEach(descriptions::add);
        }
        return descriptions;
    }

    public static <T extends NamedNode<T>, E extends T> List<String> buildFromComments(ExtendedDefinition<T, E> extendedDefinition) {
        T definition = extendedDefinition.getDefinition();
        List<E> extensions = extendedDefinition.getExtensions();
        ArrayList<String> comments = new ArrayList<String>();
        if (definition != null && definition.getComments() != null) {
            definition.getComments().stream().map(Comment::getContent).filter(Utils::isNotBlank).map(String::trim).forEach(comments::add);
        }
        extensions.stream().map(Node::getComments).flatMap(Collection::stream).filter(Objects::nonNull).map(Comment::getContent).filter(Utils::isNotBlank).map(String::trim).forEach(comments::add);
        return comments;
    }
}

