/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model.builders;

import com.kobylynskyi.graphql.codegen.model.DeprecatedDefinition;
import com.kobylynskyi.graphql.codegen.model.GeneratedLanguage;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.StringValue;

public class DeprecatedDefinitionBuilder {
    private static final String REASON = "reason";
    private static final String SCALA_ANNOTATION = "deprecated";
    private static final String JAVA_ANNOTATION = "Deprecated";
    private static final String KOTLIN_ANNOTATION = "Deprecated";

    private DeprecatedDefinitionBuilder() {
    }

    public static DeprecatedDefinition build(MappingContext mappingContext, DirectivesContainer<?> directivesContainer) {
        for (Directive d : directivesContainer.getDirectives()) {
            if (!d.getName().equalsIgnoreCase(Deprecated.class.getSimpleName())) continue;
            return DeprecatedDefinitionBuilder.build(mappingContext.getGeneratedLanguage(), d);
        }
        return null;
    }

    public static DeprecatedDefinition build(GeneratedLanguage generatedLanguage, Directive directive) {
        switch (generatedLanguage) {
            case KOTLIN: {
                return new DeprecatedDefinition("Deprecated", DeprecatedDefinitionBuilder.getMessage(directive));
            }
            case SCALA: {
                return new DeprecatedDefinition(SCALA_ANNOTATION, DeprecatedDefinitionBuilder.getMessage(directive));
            }
        }
        return new DeprecatedDefinition("Deprecated");
    }

    private static String getMessage(Directive directive) {
        for (Argument argument : directive.getArguments()) {
            if (!argument.getName().equals(REASON)) continue;
            return DeprecatedDefinitionBuilder.getReasonString(directive).getValue();
        }
        return null;
    }

    private static StringValue getReasonString(Directive directive) {
        return (StringValue)directive.getArgument(REASON).getValue();
    }
}

