/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.NamedDefinition;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.ListType;
import graphql.language.NamedNode;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GraphQLTypeMapper {
    public static String getNestedTypeName(Type<?> graphqlType) {
        if (graphqlType instanceof TypeName) {
            return ((TypeName)graphqlType).getName();
        }
        if (graphqlType instanceof ListType) {
            return GraphQLTypeMapper.getNestedTypeName(((ListType)graphqlType).getType());
        }
        if (graphqlType instanceof NonNullType) {
            return GraphQLTypeMapper.getNestedTypeName(((NonNullType)graphqlType).getType());
        }
        return null;
    }

    public static String getMandatoryType(String typeName) {
        return typeName + "!";
    }

    public static List<Directive> getDirectives(NamedNode<?> def) {
        if (def instanceof DirectivesContainer) {
            return ((DirectivesContainer)def).getDirectives();
        }
        return Collections.emptyList();
    }

    public abstract String wrapIntoList(MappingContext var1, String var2, boolean var3);

    public abstract String wrapSuperTypeIntoList(MappingContext var1, String var2, boolean var3);

    public abstract String wrapApiReturnTypeIfRequired(MappingContext var1, NamedDefinition var2, String var3);

    public abstract boolean isPrimitive(String var1);

    public String getGenericsString(MappingContext mappingContext, String genericType, String typeParameter) {
        if (genericType.contains("%s")) {
            return String.format(genericType, typeParameter);
        }
        return String.format("%s<%s>", genericType, typeParameter);
    }

    public String getLanguageType(MappingContext mappingContext, Type<?> type) {
        return this.getLanguageType(mappingContext, type, null, null).getJavaName();
    }

    public NamedDefinition getLanguageType(MappingContext mappingContext, Type<?> graphqlType, String name, String parentTypeName) {
        return this.getLanguageType(mappingContext, graphqlType, name, parentTypeName, false, false);
    }

    public NamedDefinition getLanguageType(MappingContext mappingContext, Type<?> graphqlType, String name, String parentTypeName, boolean mandatory, boolean collection) {
        if (graphqlType instanceof TypeName) {
            return this.getLanguageType(mappingContext, ((TypeName)graphqlType).getName(), name, parentTypeName, mandatory, collection);
        }
        if (graphqlType instanceof ListType) {
            NamedDefinition mappedCollectionType = this.getLanguageType(mappingContext, ((ListType)graphqlType).getType(), name, parentTypeName, false, true);
            if (mappedCollectionType.isInterfaceOrUnion() && this.isInterfaceOrUnion(mappingContext, parentTypeName)) {
                mappedCollectionType.setJavaName(this.wrapSuperTypeIntoList(mappingContext, mappedCollectionType.getJavaName(), mandatory));
            } else {
                mappedCollectionType.setJavaName(this.wrapIntoList(mappingContext, mappedCollectionType.getJavaName(), mandatory));
            }
            return mappedCollectionType;
        }
        if (graphqlType instanceof NonNullType) {
            return this.getLanguageType(mappingContext, ((NonNullType)graphqlType).getType(), name, parentTypeName, true, collection);
        }
        throw new IllegalArgumentException("Unknown type: " + graphqlType);
    }

    public NamedDefinition getLanguageType(MappingContext mappingContext, String graphQLType, String name, String parentTypeName, boolean mandatory, boolean collection) {
        String langTypeName;
        boolean primitiveCanBeUsed;
        Map<String, String> customTypesMapping = mappingContext.getCustomTypesMapping();
        Set<String> serializeFieldsUsingObjectMapper = mappingContext.getUseObjectMapperForRequestSerialization();
        boolean bl = primitiveCanBeUsed = !collection;
        if (name != null && parentTypeName != null && customTypesMapping.containsKey(parentTypeName + "." + name)) {
            langTypeName = customTypesMapping.get(parentTypeName + "." + name);
            primitiveCanBeUsed = false;
        } else {
            langTypeName = mandatory && customTypesMapping.containsKey(GraphQLTypeMapper.getMandatoryType(graphQLType)) ? customTypesMapping.get(GraphQLTypeMapper.getMandatoryType(graphQLType)) : (customTypesMapping.containsKey(graphQLType) ? customTypesMapping.get(graphQLType) : DataModelMapper.getModelClassNameWithPrefixAndSuffix(mappingContext, graphQLType));
        }
        boolean serializeUsingObjectMapper = serializeFieldsUsingObjectMapper.contains(graphQLType) || serializeFieldsUsingObjectMapper.contains(parentTypeName + "." + name);
        return new NamedDefinition(langTypeName, graphQLType, this.isInterfaceOrUnion(mappingContext, graphQLType), mandatory, primitiveCanBeUsed, serializeUsingObjectMapper);
    }

    public String getTypeConsideringPrimitive(MappingContext mappingContext, NamedDefinition namedDefinition, String computedTypeName) {
        String possiblyPrimitiveType;
        String graphqlTypeName = namedDefinition.getGraphqlTypeName();
        if (namedDefinition.isMandatory() && namedDefinition.isPrimitiveCanBeUsed() && this.isPrimitive(possiblyPrimitiveType = mappingContext.getCustomTypesMapping().get(GraphQLTypeMapper.getMandatoryType(graphqlTypeName)))) {
            return possiblyPrimitiveType;
        }
        return computedTypeName;
    }

    public String getResponseReturnType(MappingContext mappingContext, NamedDefinition namedDefinition, String computedTypeName) {
        return computedTypeName;
    }

    protected boolean isInterfaceOrUnion(MappingContext mappingContext, String graphQLType) {
        return mappingContext.getInterfacesName().contains(graphQLType) || mappingContext.getUnionsNames().contains(graphQLType);
    }
}

