/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.generators.impl;

import com.kobylynskyi.graphql.codegen.generators.FilesGenerator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateFilesCreator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateType;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.RequestResponseDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInterfaceTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedUnionTypeDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ResponseProjectionGenerator
implements FilesGenerator {
    private final MappingContext mappingContext;
    private final RequestResponseDefinitionToDataModelMapper requestResponseDefinitionMapper;

    public ResponseProjectionGenerator(MappingContext mappingContext, DataModelMapperFactory dataModelMapperFactory) {
        this.mappingContext = mappingContext;
        this.requestResponseDefinitionMapper = dataModelMapperFactory.getRequestResponseDefinitionMapper();
    }

    @Override
    public List<File> generate() {
        if (!Boolean.TRUE.equals(this.mappingContext.getGenerateClient())) {
            return Collections.emptyList();
        }
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedInterfaceTypeDefinition extendedInterfaceTypeDefinition : this.mappingContext.getDocument().getInterfaceDefinitions()) {
            generatedFiles.add(this.generate(extendedInterfaceTypeDefinition));
        }
        for (ExtendedObjectTypeDefinition extendedObjectTypeDefinition : this.mappingContext.getDocument().getTypeDefinitions()) {
            generatedFiles.add(this.generate(extendedObjectTypeDefinition));
        }
        for (ExtendedUnionTypeDefinition extendedUnionTypeDefinition : this.mappingContext.getDocument().getUnionDefinitions()) {
            generatedFiles.add(this.generate(extendedUnionTypeDefinition));
        }
        return generatedFiles;
    }

    private File generate(ExtendedDefinition<?, ?> definition) {
        Map<String, Object> responseProjDataModel = this.requestResponseDefinitionMapper.mapResponseProjection(this.mappingContext, definition);
        return FreeMarkerTemplateFilesCreator.create(this.mappingContext, FreeMarkerTemplateType.RESPONSE_PROJECTION, responseProjDataModel);
    }
}

