/*
 * Decompiled with CFR 0.152.
 */
package io.github.kobylynskyi.graphql.codegen.gradle;

import com.kobylynskyi.graphql.codegen.GraphQLCodegen;
import com.kobylynskyi.graphql.codegen.java.JavaGraphQLCodegen;
import com.kobylynskyi.graphql.codegen.kotlin.KotlinGraphQLCodegen;
import com.kobylynskyi.graphql.codegen.model.ApiInterfaceStrategy;
import com.kobylynskyi.graphql.codegen.model.ApiNamePrefixStrategy;
import com.kobylynskyi.graphql.codegen.model.ApiRootInterfaceStrategy;
import com.kobylynskyi.graphql.codegen.model.GeneratedLanguage;
import com.kobylynskyi.graphql.codegen.model.GraphQLCodegenConfiguration;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.MappingConfigConstants;
import com.kobylynskyi.graphql.codegen.model.exception.LanguageNotSupportedException;
import com.kobylynskyi.graphql.codegen.scala.ScalaGraphQLCodegen;
import com.kobylynskyi.graphql.codegen.supplier.MappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.supplier.MergeableMappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.supplier.SchemaFinder;
import io.github.kobylynskyi.graphql.codegen.gradle.ParentInterfacesConfig;
import io.github.kobylynskyi.graphql.codegen.gradle.RelayConfig;
import io.github.kobylynskyi.graphql.codegen.gradle.SchemaFinderConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;

public class GraphQLCodegenGradleTask
extends DefaultTask
implements GraphQLCodegenConfiguration {
    private List<String> graphqlSchemaPaths;
    private String graphqlQueryIntrospectionResultPath;
    private final SchemaFinderConfig graphqlSchemas = new SchemaFinderConfig();
    private File outputDir;
    private Map<String, String> customTypesMapping = new HashMap<String, String>();
    private Map<String, List<String>> customAnnotationsMapping = new HashMap<String, List<String>>();
    private Map<String, List<String>> directiveAnnotationsMapping = new HashMap<String, List<String>>();
    private String packageName;
    private String apiPackageName;
    private ApiNamePrefixStrategy apiNamePrefixStrategy = MappingConfigConstants.DEFAULT_API_NAME_PREFIX_STRATEGY;
    private ApiRootInterfaceStrategy apiRootInterfaceStrategy = MappingConfigConstants.DEFAULT_API_ROOT_INTERFACE_STRATEGY;
    private ApiInterfaceStrategy apiInterfaceStrategy = MappingConfigConstants.DEFAULT_API_INTERFACE_STRATEGY;
    private String apiNamePrefix;
    private String apiNameSuffix = "Resolver";
    private String typeResolverPrefix;
    private String typeResolverSuffix = "Resolver";
    private String modelPackageName;
    private String modelNamePrefix;
    private String modelNameSuffix;
    private String apiReturnType;
    private String apiReturnListType;
    private String subscriptionReturnType;
    private Boolean generateBuilder = true;
    private Boolean generateApis = true;
    private String modelValidationAnnotation;
    private Boolean generateEqualsAndHashCode = false;
    private Boolean generateImmutableModels = false;
    private Boolean generateToString = false;
    private Boolean generateParameterizedFieldsResolvers = true;
    private Boolean generateExtensionFieldsResolvers = false;
    private Boolean generateDataFetchingEnvironmentArgumentInApis = false;
    private Boolean generateModelsForRootTypes = false;
    private Boolean useOptionalForNullableReturnTypes = false;
    private Boolean generateApisWithThrowsException = true;
    private Boolean addGeneratedAnnotation = true;
    private Boolean generateJacksonTypeIdResolver = false;
    private Set<String> fieldsWithResolvers = new HashSet<String>();
    private Set<String> fieldsWithoutResolvers = new HashSet<String>();
    private Set<String> typesAsInterfaces = new HashSet<String>();
    private final RelayConfig relayConfig = new RelayConfig();
    private Boolean generateClient;
    private String requestSuffix;
    private String responseSuffix;
    private String responseProjectionSuffix;
    private String parametrizedInputSuffix;
    private Boolean generateAllMethodInProjection = true;
    private int responseProjectionMaxDepth = 3;
    private Set<String> useObjectMapperForRequestSerialization = new HashSet<String>();
    private final ParentInterfacesConfig parentInterfaces = new ParentInterfacesConfig();
    private List<String> configurationFiles;
    private GeneratedLanguage generatedLanguage = MappingConfigConstants.DEFAULT_GENERATED_LANGUAGE;
    private Boolean generateModelOpenClasses = false;
    private Boolean initializeNullableTypes = false;
    private Boolean generateSealedInterfaces = false;
    private Boolean supportUnknownFields = false;
    private String unknownFieldsPropertyName = "userDefinedFields";

    public GraphQLCodegenGradleTask() {
        this.setGroup("codegen");
        this.setDescription("Generates Java POJOs and interfaces based on GraphQL schemas");
    }

    @TaskAction
    public void generate() throws Exception {
        MappingConfig mappingConfig = new MappingConfig();
        mappingConfig.setPackageName(this.packageName);
        mappingConfig.setCustomTypesMapping(this.customTypesMapping != null ? this.customTypesMapping : new HashMap());
        mappingConfig.setCustomAnnotationsMapping(this.customAnnotationsMapping != null ? this.customAnnotationsMapping : new HashMap());
        mappingConfig.setDirectiveAnnotationsMapping(this.directiveAnnotationsMapping != null ? this.directiveAnnotationsMapping : new HashMap());
        mappingConfig.setApiNameSuffix(this.apiNameSuffix);
        mappingConfig.setApiNamePrefix(this.apiNamePrefix);
        mappingConfig.setApiRootInterfaceStrategy(this.apiRootInterfaceStrategy);
        mappingConfig.setApiInterfaceStrategy(this.apiInterfaceStrategy);
        mappingConfig.setApiNamePrefixStrategy(this.apiNamePrefixStrategy);
        mappingConfig.setModelNamePrefix(this.modelNamePrefix);
        mappingConfig.setModelNameSuffix(this.modelNameSuffix);
        mappingConfig.setApiPackageName(this.apiPackageName);
        mappingConfig.setModelPackageName(this.modelPackageName);
        mappingConfig.setGenerateBuilder(this.generateBuilder);
        mappingConfig.setGenerateApis(this.generateApis);
        mappingConfig.setTypeResolverSuffix(this.typeResolverSuffix);
        mappingConfig.setTypeResolverPrefix(this.typeResolverPrefix);
        mappingConfig.setModelValidationAnnotation(this.modelValidationAnnotation);
        mappingConfig.setGenerateEqualsAndHashCode(this.generateEqualsAndHashCode);
        mappingConfig.setGenerateImmutableModels(this.generateImmutableModels);
        mappingConfig.setGenerateToString(this.generateToString);
        mappingConfig.setUseOptionalForNullableReturnTypes(this.useOptionalForNullableReturnTypes);
        mappingConfig.setGenerateApisWithThrowsException(this.generateApisWithThrowsException);
        mappingConfig.setAddGeneratedAnnotation(this.addGeneratedAnnotation);
        mappingConfig.setGenerateJacksonTypeIdResolver(this.generateJacksonTypeIdResolver);
        mappingConfig.setApiReturnType(this.apiReturnType);
        mappingConfig.setApiReturnListType(this.apiReturnListType);
        mappingConfig.setSubscriptionReturnType(this.subscriptionReturnType);
        mappingConfig.setGenerateParameterizedFieldsResolvers(this.generateParameterizedFieldsResolvers);
        mappingConfig.setGenerateDataFetchingEnvironmentArgumentInApis(this.generateDataFetchingEnvironmentArgumentInApis);
        mappingConfig.setGenerateExtensionFieldsResolvers(this.generateExtensionFieldsResolvers);
        mappingConfig.setGenerateModelsForRootTypes(this.generateModelsForRootTypes);
        mappingConfig.setFieldsWithResolvers(this.fieldsWithResolvers != null ? this.fieldsWithResolvers : new HashSet());
        mappingConfig.setFieldsWithoutResolvers(this.fieldsWithoutResolvers != null ? this.fieldsWithoutResolvers : new HashSet());
        mappingConfig.setTypesAsInterfaces(this.typesAsInterfaces != null ? this.typesAsInterfaces : new HashSet());
        mappingConfig.setRelayConfig((com.kobylynskyi.graphql.codegen.model.RelayConfig)this.relayConfig);
        mappingConfig.setGenerateClient(this.generateClient);
        mappingConfig.setRequestSuffix(this.requestSuffix);
        mappingConfig.setResponseSuffix(this.responseSuffix);
        mappingConfig.setResponseProjectionSuffix(this.responseProjectionSuffix);
        mappingConfig.setParametrizedInputSuffix(this.parametrizedInputSuffix);
        mappingConfig.setUseObjectMapperForRequestSerialization(this.useObjectMapperForRequestSerialization != null ? this.useObjectMapperForRequestSerialization : new HashSet());
        mappingConfig.setGenerateAllMethodInProjection(this.generateAllMethodInProjection);
        mappingConfig.setResponseProjectionMaxDepth(Integer.valueOf(this.responseProjectionMaxDepth));
        mappingConfig.setResolverParentInterface(this.getResolverParentInterface());
        mappingConfig.setQueryResolverParentInterface(this.getQueryResolverParentInterface());
        mappingConfig.setMutationResolverParentInterface(this.getMutationResolverParentInterface());
        mappingConfig.setSubscriptionResolverParentInterface(this.getSubscriptionResolverParentInterface());
        mappingConfig.setGeneratedLanguage(this.generatedLanguage);
        mappingConfig.setGenerateModelOpenClasses(this.generateModelOpenClasses.booleanValue());
        mappingConfig.setInitializeNullableTypes(this.initializeNullableTypes.booleanValue());
        mappingConfig.setSupportUnknownFields(this.isSupportUnknownFields());
        mappingConfig.setUnknownFieldsPropertyName(this.getUnknownFieldsPropertyName());
        this.instantiateCodegen(mappingConfig).generate();
    }

    private GraphQLCodegen instantiateCodegen(MappingConfig mappingConfig) throws IOException {
        java.util.Optional<MappingConfigSupplier> mappingConfigSupplier = this.buildJsonSupplier();
        GeneratedLanguage language = mappingConfigSupplier.map(Supplier::get).map(MappingConfig::getGeneratedLanguage).orElse(this.generatedLanguage);
        switch (language) {
            case JAVA: {
                return new JavaGraphQLCodegen(this.getActualSchemaPaths(), this.graphqlQueryIntrospectionResultPath, this.outputDir, mappingConfig, (MappingConfigSupplier)mappingConfigSupplier.orElse(null));
            }
            case SCALA: {
                return new ScalaGraphQLCodegen(this.getActualSchemaPaths(), this.graphqlQueryIntrospectionResultPath, this.outputDir, mappingConfig, (MappingConfigSupplier)mappingConfigSupplier.orElse(null));
            }
            case KOTLIN: {
                return new KotlinGraphQLCodegen(this.getActualSchemaPaths(), this.graphqlQueryIntrospectionResultPath, this.outputDir, mappingConfig, (MappingConfigSupplier)mappingConfigSupplier.orElse(null));
            }
        }
        throw new LanguageNotSupportedException(language);
    }

    @InputFiles
    public List<String> getActualSchemaPaths() throws IOException {
        if (this.graphqlSchemaPaths != null) {
            return this.graphqlSchemaPaths;
        }
        if (this.graphqlQueryIntrospectionResultPath != null) {
            return Collections.emptyList();
        }
        Path rootDir = this.getSchemasRootDir();
        SchemaFinder finder = new SchemaFinder(rootDir);
        finder.setRecursive(this.graphqlSchemas.isRecursive().booleanValue());
        finder.setIncludePattern(this.graphqlSchemas.getIncludePattern());
        finder.setExcludedFiles(this.graphqlSchemas.getExcludedFiles());
        return finder.findSchemas();
    }

    private Path getSchemasRootDir() {
        String rootDir = this.graphqlSchemas.getRootDir();
        if (rootDir == null) {
            return this.findDefaultResourcesDir().orElseThrow(() -> new IllegalStateException("Default resource folder not found, please provide graphqlSchemas.rootDir"));
        }
        return Paths.get(rootDir, new String[0]);
    }

    private java.util.Optional<Path> findDefaultResourcesDir() {
        return ((SourceSet)((JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getResources().getSourceDirectories().getFiles().stream().findFirst().map(File::toPath);
    }

    private java.util.Optional<MappingConfigSupplier> buildJsonSupplier() {
        if (this.configurationFiles != null && !this.configurationFiles.isEmpty()) {
            return java.util.Optional.of(new MergeableMappingConfigSupplier(this.configurationFiles));
        }
        return java.util.Optional.empty();
    }

    @InputFiles
    @Optional
    public List<String> getGraphqlSchemaPaths() {
        return this.graphqlSchemaPaths;
    }

    public void setGraphqlSchemaPaths(List<String> graphqlSchemaPaths) {
        this.graphqlSchemaPaths = graphqlSchemaPaths;
    }

    @InputFile
    @Optional
    public String getGraphqlQueryIntrospectionResultPath() {
        return this.graphqlQueryIntrospectionResultPath;
    }

    public void setGraphqlQueryIntrospectionResultPath(String graphqlQueryIntrospectionResultPath) {
        this.graphqlQueryIntrospectionResultPath = graphqlQueryIntrospectionResultPath;
    }

    @Nested
    @Optional
    public SchemaFinderConfig getGraphqlSchemas() {
        return this.graphqlSchemas;
    }

    public void graphqlSchemas(Action<? super SchemaFinderConfig> action) {
        action.execute((Object)this.graphqlSchemas);
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Input
    @Optional
    public Map<String, String> getCustomTypesMapping() {
        return this.customTypesMapping;
    }

    public void setCustomTypesMapping(Map<String, String> customTypesMapping) {
        this.customTypesMapping = customTypesMapping;
    }

    @Input
    @Optional
    public Map<String, List<String>> getCustomAnnotationsMapping() {
        return this.customAnnotationsMapping;
    }

    public void setCustomAnnotationsMapping(Map<String, List<String>> customAnnotationsMapping) {
        this.customAnnotationsMapping = customAnnotationsMapping;
    }

    @Input
    @Optional
    public Map<String, List<String>> getDirectiveAnnotationsMapping() {
        return this.directiveAnnotationsMapping;
    }

    public void setDirectiveAnnotationsMapping(Map<String, List<String>> directiveAnnotationsMapping) {
        this.directiveAnnotationsMapping = directiveAnnotationsMapping;
    }

    @Input
    @Optional
    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Input
    @Optional
    public String getModelNamePrefix() {
        return this.modelNamePrefix;
    }

    public void setModelNameSuffix(String modelNameSuffix) {
        this.modelNameSuffix = modelNameSuffix;
    }

    @Input
    @Optional
    public String getModelNameSuffix() {
        return this.modelNameSuffix;
    }

    public void setModelNamePrefix(String modelNamePrefix) {
        this.modelNamePrefix = modelNamePrefix;
    }

    @Input
    @Optional
    public String getApiPackageName() {
        return this.apiPackageName;
    }

    public void setApiPackageName(String apiPackageName) {
        this.apiPackageName = apiPackageName;
    }

    @Input
    @Optional
    public ApiRootInterfaceStrategy getApiRootInterfaceStrategy() {
        return this.apiRootInterfaceStrategy;
    }

    public void setApiRootInterfaceStrategy(ApiRootInterfaceStrategy apiRootInterfaceStrategy) {
        this.apiRootInterfaceStrategy = apiRootInterfaceStrategy;
    }

    @Input
    @Optional
    public ApiInterfaceStrategy getApiInterfaceStrategy() {
        return this.apiInterfaceStrategy;
    }

    public void setApiInterfaceStrategy(ApiInterfaceStrategy apiInterfaceStrategy) {
        this.apiInterfaceStrategy = apiInterfaceStrategy;
    }

    @Input
    @Optional
    public ApiNamePrefixStrategy getApiNamePrefixStrategy() {
        return this.apiNamePrefixStrategy;
    }

    public void setApiNamePrefixStrategy(ApiNamePrefixStrategy apiNamePrefixStrategy) {
        this.apiNamePrefixStrategy = apiNamePrefixStrategy;
    }

    @Input
    @Optional
    public String getApiNamePrefix() {
        return this.apiNamePrefix;
    }

    public void setApiNamePrefix(String apiNamePrefix) {
        this.apiNamePrefix = apiNamePrefix;
    }

    @Input
    @Optional
    public String getApiNameSuffix() {
        return this.apiNameSuffix;
    }

    public void setApiNameSuffix(String apiNameSuffix) {
        this.apiNameSuffix = apiNameSuffix;
    }

    @Input
    @Optional
    public String getModelPackageName() {
        return this.modelPackageName;
    }

    public void setModelPackageName(String modelPackageName) {
        this.modelPackageName = modelPackageName;
    }

    @Input
    @Optional
    public Boolean getGenerateBuilder() {
        return this.generateBuilder;
    }

    public void setGenerateBuilder(Boolean generateBuilder) {
        this.generateBuilder = generateBuilder;
    }

    @Input
    @Optional
    public Boolean getGenerateApis() {
        return this.generateApis;
    }

    public void setGenerateApis(Boolean generateApis) {
        this.generateApis = generateApis;
    }

    @Input
    @Optional
    public Boolean getGenerateModelsForRootTypes() {
        return this.generateModelsForRootTypes;
    }

    public void setGenerateModelsForRootTypes(Boolean generateModelsForRootTypes) {
        this.generateModelsForRootTypes = generateModelsForRootTypes;
    }

    @Input
    @Optional
    public String getModelValidationAnnotation() {
        return this.modelValidationAnnotation;
    }

    public void setModelValidationAnnotation(String modelValidationAnnotation) {
        this.modelValidationAnnotation = modelValidationAnnotation;
    }

    @Input
    @Optional
    public Boolean getGenerateEqualsAndHashCode() {
        return this.generateEqualsAndHashCode;
    }

    public void setGenerateEqualsAndHashCode(Boolean generateEqualsAndHashCode) {
        this.generateEqualsAndHashCode = generateEqualsAndHashCode;
    }

    @Input
    @Optional
    public Boolean getGenerateImmutableModels() {
        return this.generateImmutableModels;
    }

    public void setGenerateImmutableModels(Boolean generateImmutableModels) {
        this.generateImmutableModels = generateImmutableModels;
    }

    @Input
    @Optional
    public Boolean getGenerateToString() {
        return this.generateToString;
    }

    public void setGenerateToString(Boolean generateToString) {
        this.generateToString = generateToString;
    }

    @Input
    @Optional
    public String getApiReturnType() {
        return this.apiReturnType;
    }

    public void setApiReturnType(String apiReturnType) {
        this.apiReturnType = apiReturnType;
    }

    @Input
    @Optional
    public String getApiReturnListType() {
        return this.apiReturnListType;
    }

    public void setApiReturnListType(String apiReturnListType) {
        this.apiReturnListType = apiReturnListType;
    }

    @Input
    @Optional
    public String getSubscriptionReturnType() {
        return this.subscriptionReturnType;
    }

    public void setSubscriptionReturnType(String subscriptionReturnType) {
        this.subscriptionReturnType = subscriptionReturnType;
    }

    @Input
    @Optional
    public Boolean getGenerateParameterizedFieldsResolvers() {
        return this.generateParameterizedFieldsResolvers;
    }

    public void setGenerateParameterizedFieldsResolvers(Boolean generateParameterizedFieldsResolvers) {
        this.generateParameterizedFieldsResolvers = generateParameterizedFieldsResolvers;
    }

    @Input
    @Optional
    public String getTypeResolverPrefix() {
        return this.typeResolverPrefix;
    }

    public void setTypeResolverPrefix(String typeResolverPrefix) {
        this.typeResolverPrefix = typeResolverPrefix;
    }

    @Input
    @Optional
    public String getTypeResolverSuffix() {
        return this.typeResolverSuffix;
    }

    public void setTypeResolverSuffix(String typeResolverSuffix) {
        this.typeResolverSuffix = typeResolverSuffix;
    }

    @Input
    @Optional
    public Boolean getGenerateExtensionFieldsResolvers() {
        return this.generateExtensionFieldsResolvers;
    }

    public void setGenerateExtensionFieldsResolvers(Boolean generateExtensionFieldsResolvers) {
        this.generateExtensionFieldsResolvers = generateExtensionFieldsResolvers;
    }

    @Input
    @Optional
    public Boolean getGenerateDataFetchingEnvironmentArgumentInApis() {
        return this.generateDataFetchingEnvironmentArgumentInApis;
    }

    public void setGenerateDataFetchingEnvironmentArgumentInApis(Boolean generateDataFetchingEnvironmentArgumentInApis) {
        this.generateDataFetchingEnvironmentArgumentInApis = generateDataFetchingEnvironmentArgumentInApis;
    }

    @Input
    @Optional
    public Boolean getUseOptionalForNullableReturnTypes() {
        return this.useOptionalForNullableReturnTypes;
    }

    public void setUseOptionalForNullableReturnTypes(Boolean useOptionalForNullableReturnTypes) {
        this.useOptionalForNullableReturnTypes = useOptionalForNullableReturnTypes;
    }

    @Input
    @Optional
    public Boolean getGenerateApisWithThrowsException() {
        return this.generateApisWithThrowsException;
    }

    public void setGenerateApisWithThrowsException(Boolean generateApisWithThrowsException) {
        this.generateApisWithThrowsException = generateApisWithThrowsException;
    }

    @Input
    @Optional
    public Boolean getAddGeneratedAnnotation() {
        return this.addGeneratedAnnotation;
    }

    public void setAddGeneratedAnnotation(Boolean addGeneratedAnnotation) {
        this.addGeneratedAnnotation = addGeneratedAnnotation;
    }

    @Input
    @Optional
    public Boolean getGenerateJacksonTypeIdResolver() {
        return this.generateJacksonTypeIdResolver;
    }

    public void setGenerateJacksonTypeIdResolver(Boolean generateJacksonTypeIdResolver) {
        this.generateJacksonTypeIdResolver = generateJacksonTypeIdResolver;
    }

    @Input
    @Optional
    public Set<String> getFieldsWithResolvers() {
        return this.fieldsWithResolvers;
    }

    public void setFieldsWithResolvers(Set<String> fieldsWithResolvers) {
        this.fieldsWithResolvers = fieldsWithResolvers;
    }

    @Input
    @Optional
    public Set<String> getFieldsWithoutResolvers() {
        return this.fieldsWithoutResolvers;
    }

    public void setFieldsWithoutResolvers(Set<String> fieldsWithoutResolvers) {
        this.fieldsWithoutResolvers = fieldsWithoutResolvers;
    }

    @Input
    @Optional
    public Set<String> getTypesAsInterfaces() {
        return this.typesAsInterfaces;
    }

    public void setTypesAsInterfaces(Set<String> typesAsInterfaces) {
        this.typesAsInterfaces = typesAsInterfaces;
    }

    @Nested
    @Optional
    public RelayConfig getRelayConfig() {
        return this.relayConfig;
    }

    public void relayConfig(Action<? super RelayConfig> action) {
        action.execute((Object)this.relayConfig);
    }

    @Input
    @Optional
    public Boolean getGenerateClient() {
        return this.generateClient;
    }

    public void setGenerateClient(Boolean generateClient) {
        this.generateClient = generateClient;
    }

    @Input
    @Optional
    public String getRequestSuffix() {
        return this.requestSuffix;
    }

    public void setRequestSuffix(String requestSuffix) {
        this.requestSuffix = requestSuffix;
    }

    @Input
    @Optional
    public String getResponseSuffix() {
        return this.responseSuffix;
    }

    public void setResponseSuffix(String responseSuffix) {
        this.responseSuffix = responseSuffix;
    }

    @Input
    @Optional
    public String getResponseProjectionSuffix() {
        return this.responseProjectionSuffix;
    }

    public void setResponseProjectionSuffix(String responseProjectionSuffix) {
        this.responseProjectionSuffix = responseProjectionSuffix;
    }

    @Input
    @Optional
    public String getParametrizedInputSuffix() {
        return this.parametrizedInputSuffix;
    }

    public void setParametrizedInputSuffix(String parametrizedInputSuffix) {
        this.parametrizedInputSuffix = parametrizedInputSuffix;
    }

    @Input
    @Optional
    public Set<String> getUseObjectMapperForRequestSerialization() {
        return this.useObjectMapperForRequestSerialization;
    }

    public void setUseObjectMapperForRequestSerialization(Set<String> useObjectMapperForRequestSerialization) {
        this.useObjectMapperForRequestSerialization = useObjectMapperForRequestSerialization;
    }

    @Input
    @Optional
    public Boolean getGenerateAllMethodInProjection() {
        return this.generateAllMethodInProjection;
    }

    public void setGenerateAllMethodInProjection(boolean generateAllMethodInProjection) {
        this.generateAllMethodInProjection = generateAllMethodInProjection;
    }

    @Input
    @Optional
    public Integer getResponseProjectionMaxDepth() {
        return this.responseProjectionMaxDepth;
    }

    public void setResponseProjectionMaxDepth(int responseProjectionMaxDepth) {
        this.responseProjectionMaxDepth = responseProjectionMaxDepth;
    }

    @Nested
    @Optional
    public ParentInterfacesConfig getParentInterfaces() {
        return this.parentInterfaces;
    }

    public void parentInterfaces(Action<? super ParentInterfacesConfig> action) {
        action.execute((Object)this.parentInterfaces);
    }

    @Internal
    public String getQueryResolverParentInterface() {
        return this.parentInterfaces.getQueryResolver();
    }

    @Internal
    public String getMutationResolverParentInterface() {
        return this.parentInterfaces.getMutationResolver();
    }

    @Internal
    public String getSubscriptionResolverParentInterface() {
        return this.parentInterfaces.getSubscriptionResolver();
    }

    @Internal
    public String getResolverParentInterface() {
        return this.parentInterfaces.getResolver();
    }

    @InputFiles
    @Optional
    public List<String> getConfigurationFiles() {
        return this.configurationFiles;
    }

    public void setConfigurationFiles(List<String> configurationFiles) {
        this.configurationFiles = configurationFiles;
    }

    @Input
    @Optional
    public GeneratedLanguage getGeneratedLanguage() {
        return this.generatedLanguage;
    }

    public void setGeneratedLanguage(GeneratedLanguage generatedLanguage) {
        this.generatedLanguage = generatedLanguage;
    }

    @Input
    @Optional
    public Boolean isGenerateModelOpenClasses() {
        return this.generateModelOpenClasses;
    }

    public void setGenerateModelOpenClasses(Boolean generateModelOpenClasses) {
        this.generateModelOpenClasses = generateModelOpenClasses;
    }

    @Input
    @Optional
    public Boolean isInitializeNullableTypes() {
        return this.initializeNullableTypes;
    }

    public void setInitializeNullableTypes(Boolean initializeNullableTypes) {
        this.initializeNullableTypes = initializeNullableTypes;
    }

    @Input
    @Optional
    public Boolean isGenerateSealedInterfaces() {
        return this.generateSealedInterfaces;
    }

    public void setGenerateSealedInterfaces(Boolean generateSealedInterfaces) {
        this.generateSealedInterfaces = generateSealedInterfaces;
    }

    @Input
    @Optional
    public Boolean isSupportUnknownFields() {
        return this.supportUnknownFields;
    }

    public void setSupportUnknownFields(boolean supportUnknownFields) {
        this.supportUnknownFields = supportUnknownFields;
    }

    @Input
    @Optional
    public String getUnknownFieldsPropertyName() {
        return this.unknownFieldsPropertyName;
    }

    public void setUnknownFieldsPropertyName(String unknownFieldsPropertyName) {
        this.unknownFieldsPropertyName = unknownFieldsPropertyName;
    }
}

