/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dialect.springdata;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.dialect.springdata.util.Messages;
import org.thymeleaf.dialect.springdata.util.PageUtils;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

final class PageSizeSelectorAttrProcessor
extends AbstractAttributeTagProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageSizeSelectorAttrProcessor.class);
    private static final String MESSAGE_PREFIX = "page.size.selector.";
    private static final String DEFAULT_STYLE = "page.size.selector.default";
    private static final String ATTR_NAME = "page-size-selector";
    private static final int PRECEDENCE = 900;
    private static final String BUNDLE_NAME = "PageSizeSelector";
    private static final String SELECTOR_VALUES = "page.size.selector.values";
    private final List<Integer> selectorValues = new ArrayList<Integer>();

    PageSizeSelectorAttrProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, null, false, ATTR_NAME, true, 900, true);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        Locale locale = context.getLocale();
        this.loadSelectorValues(locale);
        String selectorStyle = String.valueOf(attributeValue).trim();
        String messageKey = this.getMessageKey(selectorStyle);
        String options = this.composeSelectorOptions(selectorStyle, context);
        String message = Messages.getMessage(BUNDLE_NAME, messageKey, locale, options);
        structureHandler.setBody((CharSequence)message, false);
    }

    private void loadSelectorValues(Locale locale) {
        if (this.selectorValues.isEmpty()) {
            String[] values;
            String property = Messages.getMessage(BUNDLE_NAME, SELECTOR_VALUES, locale);
            for (String value : values = property.split(",")) {
                try {
                    this.selectorValues.add(Integer.parseInt(value.trim()));
                }
                catch (Exception e) {
                    LOGGER.error("Invalid page size value: {}", (Object)value, (Object)e);
                }
            }
        }
    }

    private String getMessageKey(String selectorStyle) {
        return "".equals(selectorStyle) ? DEFAULT_STYLE : MESSAGE_PREFIX.concat(selectorStyle);
    }

    private String composeSelectorOptions(String selectorStyle, ITemplateContext context) {
        Page<?> page = PageUtils.findPage(context);
        int currentPageSize = page.getSize();
        Locale locale = context.getLocale();
        StringBuilder sb = new StringBuilder();
        for (int value : this.selectorValues) {
            String url = PageUtils.createPageSizeUrl(context, value);
            boolean isSelectedValue = value == currentPageSize;
            String messageKey = this.getMessageKey(selectorStyle).concat(isSelectedValue ? ".option.selected" : ".option");
            String option = Messages.getMessage(BUNDLE_NAME, messageKey, locale, value, url);
            sb.append(option);
        }
        return sb.toString();
    }
}

