/*
 * Decompiled with CFR 0.152.
 */
package io.github.joke.spockmockable.ast.visitors;

import io.github.joke.spockmockable.ast.ClassCollector;
import io.github.joke.spockmockable.ast.scopes.ClassNodeScope;
import io.github.joke.spockmockable.shadow.javax.inject.Inject;
import java.util.Collections;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.jetbrains.annotations.Nullable;
import org.spockframework.util.Identifiers;

@ClassNodeScope
public class MockVisitor {
    private static final SortedSet<String> METHOD_IDENTIFIER = Identifiers.BUILT_IN_METHODS.stream().map(builtIn -> builtIn + "Impl").collect(Collectors.collectingAndThen(Collectors.toCollection(TreeSet::new), Collections::unmodifiableSortedSet));
    private final SourceUnit sourceUnit;
    private final ClassCollector classCollector;

    public void visit(MethodCallExpression origin) {
        new Visitor(origin).visitMethodCallExpression(origin);
    }

    @Inject
    @Generated
    public MockVisitor(SourceUnit sourceUnit, ClassCollector classCollector) {
        this.sourceUnit = sourceUnit;
        this.classCollector = classCollector;
    }

    private class Visitor
    extends CodeVisitorSupport {
        private final MethodCallExpression origin;
        boolean classDetected = false;

        public void visitMethodCallExpression(MethodCallExpression call) {
            String methodName = call.getMethodAsString();
            if (methodName != null && METHOD_IDENTIFIER.contains(methodName)) {
                call.getArguments().visit((GroovyCodeVisitor)this);
            }
        }

        public void visitClassExpression(ClassExpression expression) {
            Optional clazz = Optional.of(expression).map(Expression::getType).flatMap(this::extractClass);
            this.checkAndLogError(clazz.orElse(null));
        }

        public void visitVariableExpression(VariableExpression expression) {
            Optional clazz = Optional.of(expression).map(VariableExpression::getAccessedVariable).map(Variable::getType).flatMap(this::extractClass);
            this.checkAndLogError(clazz.orElse(null));
        }

        protected void logError() {
            MockVisitor.this.sourceUnit.getErrorCollector().addErrorAndContinue("Unable to determine expression type. This primarily happens when passing a dynamic typed variable to Spy().\nPlease rewrite your test either way:\n--------------------------------\ndef person = createInstance()\nPerson mySpy = Spy(person)\n-------------- or --------------\nPerson person = createInstance()\ndef mySpy = Spy(person)\n--------------------------------\n", (ASTNode)this.origin, MockVisitor.this.sourceUnit);
        }

        protected Optional<Class<?>> extractClass(ClassNode classNode) {
            return Optional.of(classNode).map(ClassNode::getTypeClass).filter(c -> !"java.lang.Object".equals(c.getCanonicalName())).map(c -> c);
        }

        protected void checkAndLogError(@Nullable Class<?> clazz) {
            if (clazz != null) {
                this.classDetected = true;
                this.traverseClassHierarchy(clazz);
            } else if (!this.classDetected) {
                this.logError();
            }
        }

        protected void traverseClassHierarchy(Class<?> clazz) {
            Class<?> current = clazz;
            while (this.isTransformable(current)) {
                MockVisitor.this.classCollector.addClass(current);
                current = current.getSuperclass();
            }
        }

        protected boolean isTransformable(Class<?> clazz) {
            return clazz != Object.class && !clazz.isInterface();
        }

        @Generated
        public Visitor(MethodCallExpression origin) {
            this.origin = origin;
        }
    }
}

