/*
 * Decompiled with CFR 0.152.
 */
package io.github.joke.spockmockable.ast.visitors;

import io.github.joke.spockmockable.ast.IsolationAnnotator;
import io.github.joke.spockmockable.ast.scopes.ClassNodeScope;
import io.github.joke.spockmockable.shadow.javax.inject.Inject;
import lombok.Generated;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;

@ClassNodeScope
public class InteractionVisitor {
    private final IsolationAnnotator isolationAnnotator;

    public void visit(MethodCallExpression origin) {
        String methodName = origin.getMethodAsString();
        if ("addInteraction".equals(methodName)) {
            origin.getArguments().visit((GroovyCodeVisitor)new Visitor());
        }
    }

    @Inject
    @Generated
    public InteractionVisitor(IsolationAnnotator isolationAnnotator) {
        this.isolationAnnotator = isolationAnnotator;
    }

    private class Visitor
    extends CodeVisitorSupport {
        public void visitMethodCallExpression(MethodCallExpression call) {
            String methodName = call.getMethodAsString();
            if ("addEqualTarget".equals(methodName)) {
                call.getArguments().visit((GroovyCodeVisitor)new TargetTypeVisitor());
            }
            call.getObjectExpression().visit((GroovyCodeVisitor)this);
        }

        @Generated
        public Visitor() {
        }
    }

    private class TargetTypeVisitor
    extends CodeVisitorSupport {
        private TargetTypeVisitor() {
        }

        public void visitClassExpression(ClassExpression expression) {
            InteractionVisitor.this.isolationAnnotator.addIsolationAnnotation();
        }
    }
}

