/*
 * Decompiled with CFR 0.152.
 */
package io.github.joke.spockmockable.agent;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.Callable;
import lombok.Generated;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spockframework.mock.CallRealMethodResponse;
import org.spockframework.mock.CannotInvokeRealMethodException;
import org.spockframework.mock.IDefaultResponse;
import org.spockframework.mock.IMockController;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.IMockMethod;
import org.spockframework.mock.IMockObject;
import org.spockframework.mock.IResponseGenerator;
import org.spockframework.mock.runtime.FailingRealMethodInvoker;
import org.spockframework.mock.runtime.MockInvocation;
import org.spockframework.mock.runtime.MockObject;
import org.spockframework.mock.runtime.StaticMockMethod;
import spock.lang.Specification;

public class StaticMockHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StaticMockHandler.class);
    @Generated
    private static final Object $LOCK = new Object[0];
    @Nullable
    private static Specification specification;
    @Nullable
    private static IMockController featureMockController;

    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    @Nullable
    public static Callable<?> onMethodEnter(@Advice.Origin Class<?> type, @Advice.Origin Method origin, Object ... arguments) throws Throwable {
        return StaticMockHandler.determineMockValue(type, origin, arguments);
    }

    @Advice.OnMethodExit
    public static void onMethodExit(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Object returned, @Advice.Enter Callable<?> interactionResult) throws Throwable {
        returned = StaticMockHandler.determineReturnValue(returned, interactionResult);
    }

    @Nullable
    public static ReturnWrapper determineMockValue(Class<?> type, Method origin, Object ... arguments) {
        MockInvocation mockInvocation = StaticMockHandler.buildMockInvocation(type, origin, arguments);
        try {
            return StaticMockHandler.getInteractionValue(mockInvocation);
        }
        catch (CannotInvokeRealMethodException e) {
            return null;
        }
    }

    @Nullable
    public static ReturnWrapper getInteractionValue(MockInvocation mockInvocation) {
        return Optional.ofNullable(featureMockController).map(mockController -> mockController.handle((IMockInvocation)mockInvocation)).map(x$0 -> new ReturnWrapper(x$0)).orElse(null);
    }

    @NotNull
    public static MockInvocation buildMockInvocation(Class<?> type, Method origin, Object[] arguments) {
        String name = String.format("global spy for %s", type.getSimpleName());
        MockObject mockObject = new MockObject(name, type, type, true, true, (IDefaultResponse)CallRealMethodResponse.INSTANCE, specification, null);
        StaticMockMethod staticMockMethod = new StaticMockMethod(origin, type);
        return new MockInvocation((IMockObject)mockObject, (IMockMethod)staticMockMethod, Arrays.asList(arguments), (IResponseGenerator)new FailingRealMethodInvoker(""));
    }

    public static Object determineReturnValue(Object returned, Callable<?> mocked) throws Exception {
        return mocked != null ? mocked.call() : returned;
    }

    @Nullable
    @Generated
    public static Specification getSpecification() {
        return specification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static void setSpecification(@Nullable Specification specification) {
        Object object = $LOCK;
        synchronized (object) {
            StaticMockHandler.specification = specification;
        }
    }

    @Nullable
    @Generated
    public static IMockController getFeatureMockController() {
        return featureMockController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static void setFeatureMockController(@Nullable IMockController featureMockController) {
        Object object = $LOCK;
        synchronized (object) {
            StaticMockHandler.featureMockController = featureMockController;
        }
    }

    static final class ReturnWrapper
    implements Callable<Object> {
        private final Object value;

        @Override
        public Object call() {
            return this.value;
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReturnWrapper)) {
                return false;
            }
            ReturnWrapper other = (ReturnWrapper)o;
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "StaticMockHandler.ReturnWrapper(value=" + this.getValue() + ")";
        }

        @Generated
        private ReturnWrapper(Object value) {
            this.value = value;
        }
    }
}

