/*
 * Decompiled with CFR 0.152.
 */
package io.github.joke.spockmockable.agent;

import io.github.joke.spockmockable.shadow.javax.inject.Inject;
import io.github.joke.spockmockable.shadow.javax.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spockframework.runtime.extension.ExtensionException;

@Singleton
public class PropertyReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertyReader.class);
    private static final String METHODS_FILE = "/META-INF/spock-mockable.properties";
    private final AtomicReference<Object> properties = new AtomicReference();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Properties load() {
        Properties properties2 = new Properties();
        try (InputStream stream = this.getClass().getResourceAsStream(METHODS_FILE);){
            if (stream == null) {
                log.warn("@Mockable did not find the generated properties file '{}'. Either you did not annotate any tests or the build setup is broken.", (Object)METHODS_FILE);
                Properties properties3 = properties2;
                return properties3;
            }
            properties2.load(stream);
            Properties properties = properties2;
            return properties;
        }
        catch (IOException e) {
            throw this.createExtensionException(e);
        }
    }

    private ExtensionException createExtensionException(IOException e) {
        return new ExtensionException("Unable to read properties file '%s' containing mockable class information", (Throwable)e).withArgs(new Object[]{METHODS_FILE});
    }

    @Inject
    @Generated
    public PropertyReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @Generated
    public Properties getProperties() {
        Object value = this.properties.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.properties;
            synchronized (atomicReference) {
                value = this.properties.get();
                if (value == null) {
                    Properties actualValue = this.load();
                    value = actualValue == null ? this.properties : actualValue;
                    this.properties.set(value);
                }
            }
        }
        return (Properties)(value == this.properties ? null : value);
    }
}

