/*
 * Decompiled with CFR 0.152.
 */
package io.github.jklingsporn.vertx.jooq.async.future;

import io.github.jklingsporn.vertx.jooq.async.future.AsyncJooqSQLClient;
import io.github.jklingsporn.vertx.jooq.async.shared.VertxPojo;
import io.vertx.core.json.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DAO;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.UniqueKey;
import org.jooq.UpdatableRecord;
import org.jooq.impl.DSL;

public interface VertxDAO<R extends UpdatableRecord<R>, P extends VertxPojo, T>
extends DAO<R, P, T> {
    public AsyncJooqSQLClient client();

    public void setClient(AsyncJooqSQLClient var1);

    public Function<JsonObject, P> jsonMapper();

    default public CompletableFuture<Boolean> existsByIdAsync(T id) {
        return this.findByIdAsync(id).thenApply(p -> p != null);
    }

    default public CompletableFuture<Long> countAsync() {
        return this.client().fetchOne((Query)DSL.using((Configuration)this.configuration()).selectCount().from((TableLike)this.getTable()), json -> json.getMap().values().stream().findFirst()).thenApply(opt -> (Long)opt.get());
    }

    default public CompletableFuture<List<P>> findAllAsync() {
        return this.fetchAsync(DSL.trueCondition());
    }

    default public CompletableFuture<P> findByIdAsync(T id) {
        UniqueKey uk = this.getTable().getPrimaryKey();
        Objects.requireNonNull(uk, () -> "No primary key");
        TableField[] pk = uk.getFieldsArray();
        Condition condition = pk.length == 1 ? pk[0].equal(pk[0].getDataType().convert(id)) : DSL.row((Field[])pk).equal((Record)id);
        return this.fetchOneAsync(condition);
    }

    default public <Z> CompletableFuture<P> fetchOneAsync(Field<Z> field, Z value) {
        return this.fetchOneAsync(field.eq(value));
    }

    default public <Z> CompletableFuture<P> fetchOneAsync(Condition condition) {
        return this.client().fetchOne((Query)DSL.using((Configuration)this.configuration()).selectFrom(this.getTable()).where(new Condition[]{condition}), this.jsonMapper());
    }

    default public <Z> CompletableFuture<Optional<P>> fetchOptionalAsync(Field<Z> field, Z value) {
        return this.fetchOneAsync(field, value).thenApply(Optional::ofNullable);
    }

    default public <Z> CompletableFuture<List<P>> fetchAsync(Field<Z> field, Collection<Z> values) {
        return this.fetchAsync(field.in(values));
    }

    default public CompletableFuture<List<P>> fetchAsync(Condition condition) {
        return this.client().fetch((Query)DSL.using((Configuration)this.configuration()).selectFrom(this.getTable()).where(new Condition[]{condition}), this.jsonMapper());
    }

    default public CompletableFuture<Integer> deleteExecAsync(T id) {
        UniqueKey uk = this.getTable().getPrimaryKey();
        Objects.requireNonNull(uk, () -> "No primary key");
        TableField[] pk = uk.getFieldsArray();
        Condition condition = pk.length == 1 ? pk[0].equal(pk[0].getDataType().convert(id)) : DSL.row((Field[])pk).equal((Record)id);
        return this.deleteExecAsync(condition);
    }

    default public <Z> CompletableFuture<Integer> deleteExecAsync(Condition condition) {
        return this.client().execute((Query)DSL.using((Configuration)this.configuration()).deleteFrom(this.getTable()).where(new Condition[]{condition}));
    }

    default public <Z> CompletableFuture<Integer> deleteExecAsync(Field<Z> field, Z value) {
        return this.deleteExecAsync(field.eq(value));
    }

    default public CompletableFuture<Integer> updateExecAsync(P object) {
        DSLContext dslContext = DSL.using((Configuration)this.configuration());
        return this.client().execute((Query)dslContext.update(this.getTable()).set(dslContext.newRecord(this.getTable(), object)));
    }

    default public CompletableFuture<Integer> insertExecAsync(P object) {
        return this.client().execute((Query)DSL.using((Configuration)this.configuration()).insertInto(this.getTable()).values(object.toJson().getMap().values()));
    }

    default public CompletableFuture<T> insertReturningPrimaryAsync(P object) {
        throw new UnsupportedOperationException(":(");
    }
}

