/*
 * Decompiled with CFR 0.152.
 */
package io.github.jhipster.config;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface JHipsterDefaults {

    public static interface AuditEvents {
        public static final int retentionPeriod = 30;
    }

    public static interface ClientApp {
        public static final String name = "jhipsterApp";
    }

    public static interface Registry {
        public static final String password = null;
    }

    public static interface Ribbon {
        public static final String[] displayOnActiveProfiles = null;
    }

    public static interface Gateway {
        public static final Map<String, List<String>> authorizedMicroservicesEndpoints = new LinkedHashMap<String, List<String>>();

        public static interface RateLimiting {
            public static final boolean enabled = false;
            public static final long limit = 100000L;
            public static final int durationInSeconds = 3600;
        }
    }

    public static interface Social {
        public static final String redirectAfterSignIn = "/#/home";
    }

    public static interface Logging {
        public static final boolean useJsonFormat = false;

        public static interface Logstash {
            public static final boolean enabled = false;
            public static final String host = "localhost";
            public static final int port = 5000;
            public static final int queueSize = 512;
        }
    }

    public static interface Metrics {

        public static interface Prometheus {
            public static final boolean enabled = false;
            public static final String endpoint = "/prometheusMetrics";
        }

        public static interface Logs {
            public static final boolean enabled = false;
            public static final long reportFrequency = 60L;
        }

        public static interface Jmx {
            public static final boolean enabled = false;
        }
    }

    public static interface Swagger {
        public static final String title = "Application API";
        public static final String description = "API documentation";
        public static final String version = "0.0.1";
        public static final String termsOfServiceUrl = null;
        public static final String contactName = null;
        public static final String contactUrl = null;
        public static final String contactEmail = null;
        public static final String license = null;
        public static final String licenseUrl = null;
        public static final String defaultIncludePattern = "/api/.*";
        public static final String host = null;
        public static final String[] protocols = new String[0];
        public static final boolean useDefaultResponseMessages = true;
    }

    public static interface Security {

        public static interface RememberMe {
            public static final String key = null;
        }

        public static interface Authentication {

            public static interface Jwt {
                public static final String secret = null;
                public static final String base64Secret = null;
                public static final long tokenValidityInSeconds = 1800L;
                public static final long tokenValidityInSecondsForRememberMe = 2592000L;
            }
        }

        public static interface ClientAuthorization {
            public static final String accessTokenUri = null;
            public static final String tokenServiceId = null;
            public static final String clientId = null;
            public static final String clientSecret = null;
        }
    }

    public static interface Mail {
        public static final boolean enabled = false;
        public static final String from = "";
        public static final String baseUrl = "";
    }

    public static interface Cache {

        public static interface Redis {
            public static final String[] server = new String[]{"redis://localhost:6379"};
            public static final int expiration = 300;
            public static final boolean cluster = false;
            public static final int connectionPoolSize = 64;
            public static final int connectionMinimumIdleSize = 24;
            public static final int subscriptionConnectionPoolSize = 50;
            public static final int subscriptionConnectionMinimumIdleSize = 1;
        }

        public static interface Memcached {
            public static final boolean enabled = false;
            public static final String servers = "localhost:11211";
            public static final int expiration = 300;
            public static final boolean useBinaryProtocol = true;

            public static interface Authentication {
                public static final boolean enabled = false;
            }
        }

        public static interface Infinispan {
            public static final String configFile = "default-configs/default-jgroups-tcp.xml";
            public static final boolean statsEnabled = false;

            public static interface Replicated {
                public static final long timeToLiveSeconds = 60L;
                public static final long maxEntries = 100L;
            }

            public static interface Distributed {
                public static final long timeToLiveSeconds = 60L;
                public static final long maxEntries = 100L;
                public static final int instanceCount = 1;
            }

            public static interface Local {
                public static final long timeToLiveSeconds = 60L;
                public static final long maxEntries = 100L;
            }
        }

        public static interface Ehcache {
            public static final int timeToLiveSeconds = 3600;
            public static final long maxEntries = 100L;
        }

        public static interface Caffeine {
            public static final int timeToLiveSeconds = 3600;
            public static final long maxEntries = 100L;
        }

        public static interface Hazelcast {
            public static final int timeToLiveSeconds = 3600;
            public static final int backupCount = 1;

            public static interface ManagementCenter {
                public static final boolean enabled = false;
                public static final int updateInterval = 3;
                public static final String url = "";
            }
        }
    }

    public static interface Http {

        public static interface Cache {
            public static final int timeToLiveInDays = 1461;
        }
    }

    public static interface Async {
        public static final int corePoolSize = 2;
        public static final int maxPoolSize = 50;
        public static final int queueCapacity = 10000;
    }
}

