/*
 * Decompiled with CFR 0.152.
 */
package io.github.jhipster.web.filter.reactive;

import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CachingHttpHeadersFilter
implements WebFilter {
    private final long cacheTimeToLive;

    public CachingHttpHeadersFilter(Long cacheTimeToLive) {
        this.cacheTimeToLive = cacheTimeToLive;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return ServerWebExchangeMatchers.pathMatchers((String[])new String[]{"/i18n/**", "/content/**", "/app/**"}).matches(exchange).filter(ServerWebExchangeMatcher.MatchResult::isMatch).doOnNext(matchResult -> {
            ServerHttpResponse response = exchange.getResponse();
            response.getHeaders().setCacheControl("max-age=" + this.cacheTimeToLive + ", public");
            response.getHeaders().setPragma("cache");
            response.getHeaders().setExpires(this.cacheTimeToLive + System.currentTimeMillis());
        }).then(Mono.defer(() -> chain.filter(exchange)));
    }
}

