/*
 * Decompiled with CFR 0.152.
 */
package io.github.jhipster.config.apidoc;

import io.github.jhipster.config.JHipsterProperties;
import io.github.jhipster.config.apidoc.customizer.JHipsterSwaggerCustomizer;
import io.github.jhipster.config.apidoc.customizer.SwaggerCustomizer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.DispatcherServlet;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={ApiInfo.class, BeanValidatorPluginsConfiguration.class, Servlet.class, DispatcherServlet.class})
@Profile(value={"swagger"})
@AutoConfigureAfter(value={JHipsterProperties.class})
@EnableSwagger2
@Import(value={BeanValidatorPluginsConfiguration.class})
public class SwaggerAutoConfiguration {
    static final String STARTING_MESSAGE = "Starting Swagger";
    static final String STARTED_MESSAGE = "Started Swagger in {} ms";
    static final String MANAGEMENT_TITLE_SUFFIX = "Management API";
    static final String MANAGEMENT_GROUP_NAME = "management";
    static final String MANAGEMENT_DESCRIPTION = "Management endpoints documentation";
    private final Logger log = LoggerFactory.getLogger(SwaggerAutoConfiguration.class);
    private final JHipsterProperties.Swagger properties;

    public SwaggerAutoConfiguration(JHipsterProperties jHipsterProperties) {
        this.properties = jHipsterProperties.getSwagger();
    }

    @Bean
    @ConditionalOnMissingBean(name={"swaggerSpringfoxApiDocket"})
    public Docket swaggerSpringfoxApiDocket(List<SwaggerCustomizer> swaggerCustomizers, ObjectProvider<AlternateTypeRule[]> alternateTypeRules) {
        this.log.debug(STARTING_MESSAGE);
        StopWatch watch = new StopWatch();
        watch.start();
        Docket docket = this.createDocket();
        swaggerCustomizers.forEach(customizer -> customizer.customize(docket));
        Optional.ofNullable(alternateTypeRules.getIfAvailable()).ifPresent(arg_0 -> ((Docket)docket).alternateTypeRules(arg_0));
        watch.stop();
        this.log.debug(STARTED_MESSAGE, (Object)watch.getTotalTimeMillis());
        return docket;
    }

    @Bean
    public JHipsterSwaggerCustomizer jHipsterSwaggerCustomizer() {
        return new JHipsterSwaggerCustomizer(this.properties);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties"})
    @ConditionalOnProperty(value={"management.endpoints.web.base-path"})
    @ConditionalOnExpression(value="'${management.endpoints.web.base-path}'.length() > 0")
    @ConditionalOnMissingBean(name={"swaggerSpringfoxManagementDocket"})
    public Docket swaggerSpringfoxManagementDocket(@Value(value="${spring.application.name:application}") String appName, @Value(value="${management.endpoints.web.base-path}") String managementContextPath) {
        ApiInfo apiInfo = new ApiInfo(StringUtils.capitalize((String)appName) + " " + MANAGEMENT_TITLE_SUFFIX, MANAGEMENT_DESCRIPTION, this.properties.getVersion(), "", ApiInfo.DEFAULT_CONTACT, "", "", new ArrayList());
        return this.createDocket().apiInfo(apiInfo).useDefaultResponseMessages(this.properties.isUseDefaultResponseMessages()).groupName(MANAGEMENT_GROUP_NAME).host(this.properties.getHost()).protocols(new HashSet<String>(Arrays.asList(this.properties.getProtocols()))).forCodeGeneration(true).directModelSubstitute(ByteBuffer.class, String.class).genericModelSubstitutes(new Class[]{ResponseEntity.class}).select().paths(PathSelectors.regex((String)(managementContextPath + ".*"))).build();
    }

    protected Docket createDocket() {
        return new Docket(DocumentationType.SWAGGER_2);
    }
}

