/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateMeter {
    private static final Logger LOG = LoggerFactory.getLogger(RateMeter.class);
    private final int quantity;
    private final long durationMilliseconds;
    private final Queue<Long> ticketTimestamps = new LinkedList<Long>();
    private final ReentrantLock lock = new ReentrantLock();

    public RateMeter(int quantity, long durationMilliseconds) {
        this.quantity = quantity;
        this.durationMilliseconds = durationMilliseconds;
    }

    public void checkRateLimit() throws InterruptedException {
        this.lock.lock();
        try {
            long waitTime = this.calculateWaitTime();
            if (waitTime > 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Rate limit reached. Waiting for {}ms.", (Object)waitTime);
                }
                Thread.sleep(waitTime);
            }
            this.recordRequest();
        }
        finally {
            this.lock.unlock();
        }
    }

    private long calculateWaitTime() {
        long now = System.currentTimeMillis();
        while (!this.ticketTimestamps.isEmpty() && this.ticketTimestamps.peek() < now - this.durationMilliseconds) {
            this.ticketTimestamps.poll();
        }
        if (this.ticketTimestamps.size() >= this.quantity) {
            long oldestTimestamp = this.ticketTimestamps.peek();
            long waitTime = oldestTimestamp + this.durationMilliseconds - now;
            return Math.max(waitTime, 0L);
        }
        return 0L;
    }

    private void recordRequest() {
        long now = System.currentTimeMillis();
        while (!this.ticketTimestamps.isEmpty() && this.ticketTimestamps.peek() < now - this.durationMilliseconds) {
            this.ticketTimestamps.poll();
        }
        this.ticketTimestamps.add(now);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rate limit usage: {}/{} in the last {}ms", new Object[]{this.ticketTimestamps.size(), this.quantity, this.durationMilliseconds});
        }
    }

    public int getQuantity() {
        return this.quantity;
    }

    public long getDuration() {
        return this.durationMilliseconds;
    }
}

