/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) 2023-2025 Jeremy Long. All Rights Reserved.
 */
package io.github.jeremylong.openvulnerability.client.ghsa;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

/**
 * Base class for pageable responses from the GitHub Security Advisory API.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class AbstractPageable implements Serializable {

    /**
     * Serialization version UID.
     */
    private static final long serialVersionUID = 7420520124100919177L;
    /**
     * The total count of items.
     */
    @JsonProperty(value = "totalCount", access = JsonProperty.Access.WRITE_ONLY)
    private int totalCount;

    /**
     * Information about pagination.
     */
    @JsonProperty(value = "pageInfo", access = JsonProperty.Access.WRITE_ONLY)
    private PageInfo pageInfo;

    /**
     * Returns the total count of items.
     *
     * @return the total count
     */
    @JsonIgnore
    int getTotalCount() {
        return totalCount;
    }

    /**
     * Returns the page information.
     *
     * @return the page information
     */
    @JsonIgnore()
    PageInfo getPageInfo() {
        return pageInfo;
    }

}
