/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) 2023 Jeremy Long. All Rights Reserved.
 */
package io.github.jeremylong.openvulnerability.client.epss;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.io.Serializable;

/**
 * Exploit Prediction Scoring System (EPSS) score.
 *
 * @see <a href="https://www.first.org/epss/">https://www.first.org/epss/</a>
 */

@JsonPropertyOrder({"cve", "epss", "percentile"})
public class EpssItem implements Serializable {
    /**
     * Serialization version UID.
     */
    private static final long serialVersionUID = 5043194930534860395L;
    @JsonProperty("cve")
    String cve;
    @JsonProperty("epss")
    Double epss;
    @JsonProperty("percentile")
    Double percentile;

    public EpssItem(String cve, Double epss, Double percentile) {
        this.cve = cve;
        this.epss = epss;
        this.percentile = percentile;
    }

    public String getCve() {
        return cve;
    }

    public Double getEpss() {
        return epss;
    }

    public Double getPercentile() {
        return percentile;
    }
}
