/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.epss;

import io.github.jeremylong.openvulnerability.client.DataFeed;
import io.github.jeremylong.openvulnerability.client.epss.EpssItem;
import io.github.jeremylong.openvulnerability.client.epss.EpssResponseHandler;
import java.io.IOException;
import java.net.ProxySelector;
import java.util.List;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class EpssDataFeed
implements DataFeed<List<EpssItem>> {
    private static final String DEFAULT_LOCATION = "https://epss.cyentia.com/epss_scores-current.csv.gz";
    private final String downloadUrl;

    public EpssDataFeed() {
        this.downloadUrl = DEFAULT_LOCATION;
    }

    public EpssDataFeed(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    public List<EpssItem> download() {
        List list = null;
        HttpGet request = new HttpGet(this.downloadUrl);
        SystemDefaultRoutePlanner planner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        try (CloseableHttpClient client = HttpClientBuilder.create().setRoutePlanner((HttpRoutePlanner)planner).build();){
            list = (List)client.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)new EpssResponseHandler());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }
}

