/*
 * Decompiled with CFR 0.152.
 */
package kafka.context;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.context.ContextHelper;
import kafka.context.KafkaContexts;

public record SchemaRegistryContexts(Map<String, SchemaRegistryContext> contextMap) {
    static final ObjectMapper json = new ObjectMapper();

    public static SchemaRegistryContexts load(Path baseDir) throws IOException {
        return SchemaRegistryContexts.from(Files.readAllBytes(SchemaRegistryContexts.schemaRegistryContextConfig(baseDir)));
    }

    public static SchemaRegistryContexts load() throws IOException {
        return SchemaRegistryContexts.load(ContextHelper.baseDir());
    }

    public static void save(SchemaRegistryContexts contexts) throws IOException {
        Files.write(SchemaRegistryContexts.schemaRegistryContextConfig(ContextHelper.baseDir()), contexts.serialize(), new OpenOption[0]);
    }

    static Path schemaRegistryContextConfig(Path home) throws IOException {
        Path context = home.resolve("schema-registry.json");
        if (!Files.isRegularFile(context, new LinkOption[0])) {
            System.err.println("Schema Registry Content configuration file doesn't exist, creating one...");
            Files.write(context, KafkaContexts.empty(), new OpenOption[0]);
        }
        return context;
    }

    static SchemaRegistryContexts from(byte[] bytes) throws IOException {
        JsonNode tree = json.readTree(bytes);
        if (!tree.isArray()) {
            throw new IllegalArgumentException("JSON is not an array");
        }
        ArrayNode array = (ArrayNode)tree;
        HashMap<String, SchemaRegistryContext> contexts = new HashMap<String, SchemaRegistryContext>(array.size());
        for (JsonNode node : array) {
            SchemaRegistryContext context = SchemaRegistryContext.parse(node);
            contexts.put(context.name(), context);
        }
        return new SchemaRegistryContexts(contexts);
    }

    public String names() throws JsonProcessingException {
        return json.writeValueAsString(this.contextMap.keySet());
    }

    public byte[] serialize() throws JsonProcessingException {
        ArrayNode array = json.createArrayNode();
        for (SchemaRegistryContext ctx : this.contextMap.values()) {
            array.add(ctx.toJson());
        }
        return json.writeValueAsBytes((Object)array);
    }

    public void add(SchemaRegistryContext ctx) {
        this.contextMap.put(ctx.name, ctx);
    }

    public SchemaRegistryContext get(String name) {
        return this.contextMap.get(name);
    }

    public boolean has(String contextName) {
        return this.contextMap.containsKey(contextName);
    }

    public void remove(String name) {
        this.contextMap.remove(name);
    }

    public String namesAndUrls() throws JsonProcessingException {
        ObjectNode node = json.createObjectNode();
        this.contextMap.forEach((k, v) -> node.put(k, v.cluster().urls()));
        return json.writeValueAsString((Object)node);
    }

    public record SchemaRegistryContext(String name, SchemaRegistryCluster cluster) {
        static SchemaRegistryContext parse(JsonNode node) {
            String name = node.get("name").textValue();
            return new SchemaRegistryContext(name, SchemaRegistryCluster.parse(node.get("cluster")));
        }

        public JsonNode toJson() {
            ObjectNode node = json.createObjectNode().put("name", this.name);
            node.set("cluster", this.cluster.toJson());
            return node;
        }

        public Properties properties() {
            Properties props = new Properties();
            props.put("schema.registry.url", this.cluster.urls());
            switch (this.cluster.auth().type()) {
                case BASIC_AUTH: {
                    props.put("basic.auth.credentials.source", "USER_INFO");
                    UsernamePasswordAuth auth = (UsernamePasswordAuth)this.cluster.auth();
                    props.put("basic.auth.user.info", "%s:%s".formatted(auth.username(), ContextHelper.passwordHelper().decrypt(auth.password())));
                    break;
                }
            }
            return props;
        }

        public String kcat() {
            String urls = this.cluster().urls();
            String https = "https://";
            return switch (this.cluster.auth().type()) {
                default -> throw new IncompatibleClassChangeError();
                case SchemaRegistryAuth.AuthType.BASIC_AUTH -> "\\\n -r https://$SCHEMA_REGISTRY_USERNAME:$SCHEMA_REGISTRY_PASSWORD@" + urls.substring("https://".length()) + " -s value=avro";
                case SchemaRegistryAuth.AuthType.NO_AUTH -> "\\\n -r " + urls + " -s value=avro";
            };
        }

        public String env(boolean includeAuth) {
            String urls = this.cluster().urls();
            return switch (this.cluster.auth().type()) {
                default -> throw new IncompatibleClassChangeError();
                case SchemaRegistryAuth.AuthType.BASIC_AUTH -> {
                    if (includeAuth) {
                        yield "export SCHEMA_REGISTRY_URL=%s\nexport SCHEMA_REGISTRY_USERNAME=%s\nexport SCHEMA_REGISTRY_PASSWORD=%s".formatted(urls, ((UsernamePasswordAuth)this.cluster.auth()).username(), ContextHelper.passwordHelper().decrypt(((UsernamePasswordAuth)this.cluster.auth()).password()));
                    }
                    yield "export SCHEMA_REGISTRY_URL=%s".formatted(urls);
                }
                case SchemaRegistryAuth.AuthType.NO_AUTH -> "export SCHEMA_REGISTRY_URL=%s".formatted(urls);
            };
        }
    }

    public record SchemaRegistryCluster(String urls, SchemaRegistryAuth auth) {
        static SchemaRegistryCluster parse(JsonNode cluster) {
            return new SchemaRegistryCluster(cluster.get("urls").textValue(), SchemaRegistryAuth.parse(cluster.get("auth")));
        }

        public JsonNode toJson() {
            ObjectNode node = json.createObjectNode().put("urls", this.urls);
            node.set("auth", this.auth.toJson());
            return node;
        }
    }

    public record UsernamePasswordAuth(SchemaRegistryAuth.AuthType authType, String username, String password) implements SchemaRegistryAuth
    {
        public static SchemaRegistryAuth build(SchemaRegistryAuth.AuthType authType, String username, String password) {
            return new UsernamePasswordAuth(authType, username, ContextHelper.passwordHelper().encrypt(password));
        }

        public PasswordAuthentication passwordAuth() {
            return new PasswordAuthentication(this.username, ContextHelper.passwordHelper().decrypt(this.password).toCharArray());
        }

        @Override
        public SchemaRegistryAuth.AuthType type() {
            return this.authType;
        }

        @Override
        public JsonNode toJson() {
            ObjectNode node = (ObjectNode)SchemaRegistryAuth.super.toJson();
            return node.put("username", this.username).put("password", this.password);
        }
    }

    public record NoAuth() implements SchemaRegistryAuth
    {
        @Override
        public SchemaRegistryAuth.AuthType type() {
            return SchemaRegistryAuth.AuthType.NO_AUTH;
        }
    }

    public static interface SchemaRegistryAuth {
        public AuthType type();

        public static SchemaRegistryAuth parse(JsonNode auth) {
            AuthType type = AuthType.valueOf(auth.get("type").textValue());
            return switch (type) {
                case AuthType.BASIC_AUTH -> new UsernamePasswordAuth(type, auth.get("username").textValue(), auth.get("password").textValue());
                default -> new NoAuth();
            };
        }

        default public JsonNode toJson() {
            return json.createObjectNode().put("type", this.type().name());
        }

        public static enum AuthType {
            NO_AUTH,
            BASIC_AUTH;

        }
    }
}

