/*
 * Decompiled with CFR 0.152.
 */
package kafka.context;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.context.ContextHelper;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public record KafkaContexts(Map<String, KafkaContext> contextMap) {
    static final ObjectMapper json = new ObjectMapper();

    public static void save(KafkaContexts contexts) throws IOException {
        Files.write(KafkaContexts.kafkaContextConfig(ContextHelper.baseDir()), contexts.serialize(), new OpenOption[0]);
    }

    static Path kafkaContextConfig(Path home) throws IOException {
        Path context = home.resolve("kafka.json");
        if (!Files.isRegularFile(context, new LinkOption[0])) {
            System.err.println("Kafka Content configuration file doesn't exist, creating one...");
            Files.write(context, KafkaContexts.empty(), new OpenOption[0]);
        }
        return context;
    }

    static byte[] empty() throws JsonProcessingException {
        return json.writeValueAsBytes((Object)json.createArrayNode());
    }

    static KafkaContexts load(Path baseDir) throws IOException {
        return KafkaContexts.from(Files.readAllBytes(KafkaContexts.kafkaContextConfig(baseDir)));
    }

    public static KafkaContexts load() throws IOException {
        return KafkaContexts.load(ContextHelper.baseDir());
    }

    static KafkaContexts from(byte[] bytes) throws IOException {
        JsonNode tree = json.readTree(bytes);
        if (!tree.isArray()) {
            throw new IllegalArgumentException("JSON is not an array");
        }
        ArrayNode array = (ArrayNode)tree;
        HashMap<String, KafkaContext> contexts = new HashMap<String, KafkaContext>(array.size());
        for (JsonNode node : array) {
            KafkaContext context = KafkaContext.parse(node);
            contexts.put(context.name(), context);
        }
        return new KafkaContexts(contexts);
    }

    public String names() throws JsonProcessingException {
        return json.writeValueAsString(this.contextMap.keySet());
    }

    public byte[] serialize() throws JsonProcessingException {
        ArrayNode array = json.createArrayNode();
        for (KafkaContext ctx : this.contextMap.values()) {
            array.add(ctx.toJson());
        }
        return json.writeValueAsBytes((Object)array);
    }

    public void add(KafkaContext ctx) {
        this.contextMap.put(ctx.name, ctx);
    }

    public KafkaContext get(String name) {
        return this.contextMap.get(name);
    }

    public boolean has(String name) {
        return this.contextMap.containsKey(name);
    }

    public void remove(String name) {
        this.contextMap.remove(name);
    }

    public String namesAndBootstrapServers() throws JsonProcessingException {
        ObjectNode node = json.createObjectNode();
        this.contextMap.forEach((k, v) -> node.put(k, v.cluster().bootstrapServers()));
        return json.writeValueAsString((Object)node);
    }

    public record KafkaContext(String name, KafkaCluster cluster) {
        static KafkaContext parse(JsonNode node) {
            String name = node.get("name").textValue();
            return new KafkaContext(name, KafkaCluster.parse(node.get("cluster")));
        }

        public JsonNode toJson() {
            ObjectNode node = json.createObjectNode().put("name", this.name);
            node.set("cluster", this.cluster.toJson());
            return node;
        }

        public Properties properties() throws IOException {
            Properties props = new Properties();
            props.put("bootstrap.servers", this.cluster.bootstrapServers());
            switch (this.cluster.auth().type()) {
                case SASL_PLAIN: {
                    props.put("security.protocol", SecurityProtocol.SASL_SSL.name);
                    props.put("sasl.mechanism", "PLAIN");
                    UsernamePasswordAuth auth = (UsernamePasswordAuth)this.cluster.auth();
                    props.setProperty("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"%s\" password=\"%s\";".formatted(auth.username(), ContextHelper.passwordHelper().decrypt(auth.password())));
                    break;
                }
            }
            return props;
        }

        public String kcat() {
            return switch (this.cluster.auth().type()) {
                case KafkaAuth.AuthType.SASL_PLAIN -> "kcat -b %s -X security.protocol=SASL_SSL -X sasl.mechanisms=PLAIN \\\n -X sasl.username=$KAFKA_USERNAME -X sasl.password=$KAFKA_PASSWORD \\\n -X api.version.request=true ".formatted(this.cluster.bootstrapServers);
                default -> "kcat -b %s ".formatted(this.cluster.bootstrapServers);
            };
        }

        public String env(boolean includeAuth) {
            return switch (this.cluster.auth().type()) {
                case KafkaAuth.AuthType.SASL_PLAIN -> {
                    if (includeAuth) {
                        yield "export KAFKA_BOOTSTRAP_SERVERS=%s\nexport KAFKA_USERNAME=%s\nexport KAFKA_PASSWORD=%s".formatted(this.cluster.bootstrapServers, ((UsernamePasswordAuth)this.cluster.auth()).username, ContextHelper.passwordHelper().decrypt(((UsernamePasswordAuth)this.cluster.auth()).password));
                    }
                    yield "export KAFKA_BOOTSTRAP_SERVERS=%s".formatted(this.cluster.bootstrapServers);
                }
                default -> "export KAFKA_BOOTSTRAP_SERVERS=%s".formatted(this.cluster.bootstrapServers);
            };
        }
    }

    public record KafkaCluster(String bootstrapServers, KafkaAuth auth) {
        static KafkaCluster parse(JsonNode cluster) {
            return new KafkaCluster(cluster.get("bootstrapServers").textValue(), KafkaAuth.parse(cluster.get("auth")));
        }

        public JsonNode toJson() {
            ObjectNode node = json.createObjectNode().put("bootstrapServers", this.bootstrapServers);
            node.set("auth", this.auth.toJson());
            return node;
        }
    }

    public record UsernamePasswordAuth(KafkaAuth.AuthType authType, String username, String password) implements KafkaAuth
    {
        public static UsernamePasswordAuth build(KafkaAuth.AuthType authType, String username, String password) {
            return new UsernamePasswordAuth(authType, username, ContextHelper.passwordHelper().encrypt(password));
        }

        @Override
        public KafkaAuth.AuthType type() {
            return this.authType;
        }

        @Override
        public JsonNode toJson() {
            ObjectNode node = (ObjectNode)KafkaAuth.super.toJson();
            return node.put("username", this.username).put("password", this.password);
        }
    }

    public record NoAuth() implements KafkaAuth
    {
        @Override
        public KafkaAuth.AuthType type() {
            return KafkaAuth.AuthType.PLAINTEXT;
        }
    }

    public static interface KafkaAuth {
        public AuthType type();

        public static KafkaAuth parse(JsonNode auth) {
            AuthType type = AuthType.valueOf(auth.get("type").textValue());
            return switch (type) {
                case AuthType.SASL_PLAIN -> new UsernamePasswordAuth(type, auth.get("username").textValue(), auth.get("password").textValue());
                default -> new NoAuth();
            };
        }

        default public JsonNode toJson() {
            return json.createObjectNode().put("type", this.type().name());
        }

        public static enum AuthType {
            PLAINTEXT,
            SASL_PLAIN;

        }
    }
}

