/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import java.util.Map;
import org.agrona.collections.Int2IntHashMap;

public interface OrdinalMapper {
    public static final int OMITTED = Integer.MIN_VALUE;

    public int maxOrdinal();

    public int oldToNew(int var1);

    public int newToOld(int var1);

    public static class MapMapper
    implements OrdinalMapper {
        private final int maxOrdinal;
        private final Map<Integer, Integer> oldToNew;
        private final Int2IntHashMap newToOld;

        public MapMapper(Map<Integer, Integer> oldToNew) {
            this.oldToNew = oldToNew;
            this.newToOld = new Int2IntHashMap(oldToNew.size(), 0.65f, Integer.MIN_VALUE);
            oldToNew.forEach((old, newOrdinal) -> this.newToOld.put(newOrdinal, old));
            this.maxOrdinal = oldToNew.values().stream().mapToInt(i -> i).max().orElse(-1);
        }

        @Override
        public int maxOrdinal() {
            return this.maxOrdinal;
        }

        @Override
        public int oldToNew(int oldOrdinal) {
            return this.oldToNew.get(oldOrdinal);
        }

        @Override
        public int newToOld(int newOrdinal) {
            return this.newToOld.get(newOrdinal);
        }
    }

    public static class IdentityMapper
    implements OrdinalMapper {
        private final int maxOrdinal;

        public IdentityMapper(int maxOrdinal) {
            this.maxOrdinal = maxOrdinal;
        }

        @Override
        public int maxOrdinal() {
            return this.maxOrdinal;
        }

        @Override
        public int oldToNew(int oldOrdinal) {
            return oldOrdinal;
        }

        @Override
        public int newToOld(int newOrdinal) {
            return newOrdinal;
        }
    }
}

