/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.IndexWriter;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.OnHeapGraphIndex;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.GraphIndexWriter;
import io.github.jbellis.jvector.graph.disk.Header;
import io.github.jbellis.jvector.graph.disk.OrdinalMapper;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import io.github.jbellis.jvector.graph.disk.feature.InlineVectors;
import io.github.jbellis.jvector.graph.disk.feature.NVQ;
import io.github.jbellis.jvector.graph.disk.feature.SeparatedFeature;
import io.github.jbellis.jvector.graph.disk.feature.SeparatedNVQ;
import io.github.jbellis.jvector.graph.disk.feature.SeparatedVectors;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.agrona.collections.Int2IntHashMap;

public abstract class AbstractGraphIndexWriter<T extends IndexWriter>
implements GraphIndexWriter {
    public static final int FOOTER_MAGIC = 1247167044;
    public static final int FOOTER_OFFSET_SIZE = 8;
    public static final int FOOTER_MAGIC_SIZE = 4;
    public static final int FOOTER_SIZE = 12;
    final int version;
    final GraphIndex graph;
    final GraphIndex.View view;
    final OrdinalMapper ordinalMapper;
    final int dimension;
    final EnumMap<FeatureId, Feature> featureMap;
    final T out;
    final int headerSize;
    volatile int maxOrdinalWritten = -1;
    final List<Feature> inlineFeatures;

    AbstractGraphIndexWriter(T out, int version, GraphIndex graph, OrdinalMapper oldToNewOrdinals, int dimension, EnumMap<FeatureId, Feature> features) {
        if (graph.getMaxLevel() > 0 && version < 4) {
            throw new IllegalArgumentException("Multilayer graphs must be written with version 4 or higher");
        }
        this.version = version;
        this.graph = graph;
        this.view = graph instanceof OnHeapGraphIndex ? ((OnHeapGraphIndex)graph).getFrozenView() : graph.getView();
        this.ordinalMapper = oldToNewOrdinals;
        this.dimension = dimension;
        this.featureMap = features;
        this.inlineFeatures = features.values().stream().filter(f -> !(f instanceof SeparatedFeature)).collect(Collectors.toList());
        this.out = out;
        List<CommonHeader.LayerInfo> layerInfo = CommonHeader.LayerInfo.fromGraph(graph, this.ordinalMapper);
        CommonHeader ch = new CommonHeader(version, dimension, 0, layerInfo, 0);
        Header placeholderHeader = new Header(ch, this.featureMap);
        this.headerSize = placeholderHeader.size();
    }

    public int getMaxOrdinal() {
        return this.maxOrdinalWritten;
    }

    public Set<FeatureId> getFeatureSet() {
        return this.featureMap.keySet();
    }

    long featureOffsetForOrdinal(long startOffset, int ordinal) {
        int edgeSize = 4 * (1 + this.graph.getDegree(0));
        long inlineBytes = (long)ordinal * (long)(4 + this.inlineFeatures.stream().mapToInt(Feature::featureSize).sum() + edgeSize);
        return startOffset + (long)this.headerSize + inlineBytes + 4L;
    }

    boolean isSeparated(Feature feature) {
        return feature instanceof SeparatedFeature;
    }

    public static Map<Integer, Integer> sequentialRenumbering(GraphIndex graph) {
        Int2IntHashMap int2IntHashMap;
        block9: {
            GraphIndex.View view = graph.getView();
            try {
                Int2IntHashMap oldToNewMap = new Int2IntHashMap(-1);
                int nextOrdinal = 0;
                for (int i = 0; i < view.getIdUpperBound(); ++i) {
                    if (!graph.containsNode(i)) continue;
                    oldToNewMap.put(i, nextOrdinal++);
                }
                int2IntHashMap = oldToNewMap;
                if (view == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (view != null) {
                        try {
                            view.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            view.close();
        }
        return int2IntHashMap;
    }

    void writeFooter(long headerOffset) throws IOException {
        List<CommonHeader.LayerInfo> layerInfo = CommonHeader.LayerInfo.fromGraph(this.graph, this.ordinalMapper);
        CommonHeader commonHeader = new CommonHeader(this.version, this.dimension, this.ordinalMapper.oldToNew(this.view.entryNode().node), layerInfo, this.ordinalMapper.maxOrdinal() + 1);
        Header header = new Header(commonHeader, this.featureMap);
        header.write((IndexWriter)this.out);
        this.out.writeLong(headerOffset);
        this.out.writeInt(1247167044);
        long expectedPosition = headerOffset + (long)this.headerSize + 12L;
        assert (this.out.position() == expectedPosition) : String.format("%d != %d", this.out.position(), expectedPosition);
    }

    public synchronized void writeHeader(long startOffset) throws IOException {
        List<CommonHeader.LayerInfo> layerInfo = CommonHeader.LayerInfo.fromGraph(this.graph, this.ordinalMapper);
        CommonHeader commonHeader = new CommonHeader(this.version, this.dimension, this.ordinalMapper.oldToNew(this.view.entryNode().node), layerInfo, this.ordinalMapper.maxOrdinal() + 1);
        Header header = new Header(commonHeader, this.featureMap);
        header.write((IndexWriter)this.out);
        assert (this.out.position() == startOffset + (long)this.headerSize) : String.format("%d != %d", this.out.position(), startOffset + (long)this.headerSize);
    }

    void writeSparseLevels() throws IOException {
        for (int level = 1; level <= this.graph.getMaxLevel(); ++level) {
            int layerSize = this.graph.size(level);
            int layerDegree = this.graph.getDegree(level);
            int nodesWritten = 0;
            NodesIterator it = this.graph.getNodes(level);
            while (it.hasNext()) {
                int n;
                int originalOrdinal = it.nextInt();
                int newOrdinal = this.ordinalMapper.oldToNew(originalOrdinal);
                this.out.writeInt(newOrdinal);
                NodesIterator neighbors = this.view.getNeighborsIterator(level, originalOrdinal);
                this.out.writeInt(neighbors.size());
                for (n = 0; n < neighbors.size(); ++n) {
                    this.out.writeInt(this.ordinalMapper.oldToNew(neighbors.nextInt()));
                }
                assert (!neighbors.hasNext()) : "Mismatch between neighbor's reported size and actual size";
                while (n < layerDegree) {
                    this.out.writeInt(-1);
                    ++n;
                }
                ++nodesWritten;
            }
            if (nodesWritten == layerSize) continue;
            throw new IllegalStateException("Mismatch between layer size and nodes written");
        }
    }

    void writeSeparatedFeatures(Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers) throws IOException {
        for (Map.Entry<FeatureId, Feature> featureEntry : this.featureMap.entrySet()) {
            if (!this.isSeparated(featureEntry.getValue())) continue;
            FeatureId fid = featureEntry.getKey();
            IntFunction<Feature.State> supplier = featureStateSuppliers.get((Object)fid);
            if (supplier == null) {
                throw new IllegalStateException("Supplier for feature " + String.valueOf((Object)fid) + " not found");
            }
            SeparatedFeature feature = (SeparatedFeature)featureEntry.getValue();
            feature.setOffset(this.out.position());
            for (int newOrdinal = 0; newOrdinal <= this.ordinalMapper.maxOrdinal(); ++newOrdinal) {
                int originalOrdinal = this.ordinalMapper.newToOld(newOrdinal);
                if (originalOrdinal != Integer.MIN_VALUE) {
                    feature.writeSeparately((DataOutput)this.out, supplier.apply(originalOrdinal));
                    continue;
                }
                for (int i = 0; i < feature.featureSize(); ++i) {
                    this.out.writeByte(0);
                }
            }
        }
    }

    public static abstract class Builder<K extends AbstractGraphIndexWriter<T>, T extends IndexWriter> {
        final GraphIndex graphIndex;
        final EnumMap<FeatureId, Feature> features;
        final T out;
        OrdinalMapper ordinalMapper;
        int version;

        public Builder(GraphIndex graphIndex, T out) {
            this.graphIndex = graphIndex;
            this.out = out;
            this.features = new EnumMap(FeatureId.class);
            this.version = 5;
        }

        public Builder<K, T> withVersion(int version) {
            if (version > 5) {
                throw new IllegalArgumentException("Unsupported version: " + version);
            }
            this.version = version;
            return this;
        }

        public Builder<K, T> with(Feature feature) {
            this.features.put(feature.id(), feature);
            return this;
        }

        public Builder<K, T> withMapper(OrdinalMapper ordinalMapper) {
            this.ordinalMapper = ordinalMapper;
            return this;
        }

        public K build() throws IOException {
            int dimension;
            if (!(this.version >= 3 || this.features.containsKey((Object)FeatureId.INLINE_VECTORS) && this.features.size() <= 1)) {
                throw new IllegalArgumentException("Only INLINE_VECTORS is supported until version 3");
            }
            if (this.features.containsKey((Object)FeatureId.INLINE_VECTORS)) {
                dimension = ((InlineVectors)this.features.get((Object)FeatureId.INLINE_VECTORS)).dimension();
            } else if (this.features.containsKey((Object)FeatureId.NVQ_VECTORS)) {
                dimension = ((NVQ)this.features.get((Object)FeatureId.NVQ_VECTORS)).dimension();
            } else if (this.features.containsKey((Object)FeatureId.SEPARATED_VECTORS)) {
                dimension = ((SeparatedVectors)this.features.get((Object)FeatureId.SEPARATED_VECTORS)).dimension();
            } else if (this.features.containsKey((Object)FeatureId.SEPARATED_NVQ)) {
                dimension = ((SeparatedNVQ)this.features.get((Object)FeatureId.SEPARATED_NVQ)).dimension();
            } else {
                throw new IllegalArgumentException("Inline or separated vector feature must be provided");
            }
            if (this.ordinalMapper == null) {
                this.ordinalMapper = new OrdinalMapper.MapMapper(AbstractGraphIndexWriter.sequentialRenumbering(this.graphIndex));
            }
            return this.reallyBuild(dimension);
        }

        protected abstract K reallyBuild(int var1) throws IOException;

        public Builder<K, T> withMap(Map<Integer, Integer> oldToNewOrdinals) {
            return this.withMapper(new OrdinalMapper.MapMapper(oldToNewOrdinals));
        }

        public Feature getFeature(FeatureId featureId) {
            return this.features.get((Object)featureId);
        }
    }
}

