/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.disk.ReaderSupplier;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;

public class SimpleReader
implements RandomAccessReader {
    RandomAccessFile raf;

    public SimpleReader(Path path) throws FileNotFoundException {
        this.raf = new RandomAccessFile(path.toFile(), "r");
    }

    @Override
    public void seek(long offset) throws IOException {
        this.raf.seek(offset);
    }

    @Override
    public long getPosition() throws IOException {
        return this.raf.getFilePointer();
    }

    @Override
    public int readInt() throws IOException {
        return this.raf.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.raf.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.raf.readFloat();
    }

    @Override
    public void readFully(byte[] bytes) throws IOException {
        this.raf.readFully(bytes);
    }

    @Override
    public void readFully(ByteBuffer buffer) throws IOException {
        this.raf.getChannel().read(buffer);
    }

    @Override
    public void readFully(float[] floats) throws IOException {
        this.read(floats, 0, floats.length);
    }

    @Override
    public void readFully(long[] vector) throws IOException {
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = this.raf.readLong();
        }
    }

    @Override
    public void read(int[] ints, int offset, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            ints[offset + i] = this.raf.readInt();
        }
    }

    @Override
    public void read(float[] floats, int offset, int count) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(count * 4);
        this.raf.getChannel().read(bb);
        bb.flip().order(ByteOrder.BIG_ENDIAN);
        bb.asFloatBuffer().get(floats, offset, count);
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public long length() throws IOException {
        return this.raf.length();
    }

    public static class Supplier
    implements ReaderSupplier {
        private final Path path;

        public Supplier(Path path) {
            this.path = path;
        }

        @Override
        public RandomAccessReader get() throws FileNotFoundException {
            return new SimpleReader(this.path);
        }
    }
}

