/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.util;

import io.github.jbellis.jvector.util.ArrayUtil;
import io.github.jbellis.jvector.util.IntMap;
import io.github.jbellis.jvector.util.RamUsageEstimator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DenseIntMap<T>
implements IntMap<T> {
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private volatile AtomicReferenceArray<T> objects;
    private final AtomicInteger size;

    public DenseIntMap(int initialCapacity) {
        this.objects = new AtomicReferenceArray(initialCapacity);
        this.size = new AtomicInteger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compareAndPut(int key, T existing, T value) {
        if (value == null) {
            throw new IllegalArgumentException("compareAndPut() value cannot be null -- use remove() instead");
        }
        this.ensureCapacity(key);
        this.rwl.readLock().lock();
        try {
            boolean isInsert;
            boolean success = this.objects.compareAndSet(key, existing, value);
            boolean bl = isInsert = success && existing == null;
            if (isInsert) {
                this.size.incrementAndGet();
            }
            boolean bl2 = success;
            return bl2;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public T get(int key) {
        if (key >= this.objects.length()) {
            return null;
        }
        return this.objects.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCapacity(int node) {
        if (node < this.objects.length()) {
            return;
        }
        this.rwl.writeLock().lock();
        try {
            AtomicReferenceArray<T> oldArray = this.objects;
            if (node >= oldArray.length()) {
                int newSize = ArrayUtil.oversize(node + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
                AtomicReferenceArray<T> newArray = new AtomicReferenceArray<T>(newSize);
                for (int i = 0; i < oldArray.length(); ++i) {
                    newArray.set(i, oldArray.get(i));
                }
                this.objects = newArray;
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int key) {
        if (key >= this.objects.length()) {
            return null;
        }
        T old = this.objects.get(key);
        if (old == null) {
            return null;
        }
        this.rwl.readLock().lock();
        try {
            if (this.objects.compareAndSet(key, old, null)) {
                this.size.decrementAndGet();
                T t = old;
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    @Override
    public void forEach(IntMap.IntBiConsumer<T> consumer) {
        AtomicReferenceArray<T> ref = this.objects;
        for (int i = 0; i < ref.length(); ++i) {
            T value = this.get(i);
            if (value == null) continue;
            consumer.consume(i, value);
        }
    }
}

